/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.world;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.world.PalladiumConfiguredFeatures;

public class PalladiumPlacedFeatures {
    public static final ResourceKey<PlacedFeature> ORE_LEAD_UPPER = PalladiumPlacedFeatures.createKey("ore_lead_upper");
    public static final ResourceKey<PlacedFeature> ORE_LEAD_MIDDLE = PalladiumPlacedFeatures.createKey("ore_lead_middle");
    public static final ResourceKey<PlacedFeature> ORE_LEAD_SMALL = PalladiumPlacedFeatures.createKey("ore_lead_small");
    public static final ResourceKey<PlacedFeature> UNDERGROUND_VIBRANIUM_METEORITE = PalladiumPlacedFeatures.createKey("underground_vibranium_meteorite");

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        PalladiumPlacedFeatures.register(context, ORE_LEAD_UPPER, configuredFeatures.m_255043_(PalladiumConfiguredFeatures.ORE_LEAD), PalladiumPlacedFeatures.commonOrePlacement(90, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)80), (VerticalAnchor)VerticalAnchor.m_158922_((int)384))));
        PalladiumPlacedFeatures.register(context, ORE_LEAD_MIDDLE, configuredFeatures.m_255043_(PalladiumConfiguredFeatures.ORE_LEAD), PalladiumPlacedFeatures.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-24), (VerticalAnchor)VerticalAnchor.m_158922_((int)56))));
        PalladiumPlacedFeatures.register(context, ORE_LEAD_SMALL, configuredFeatures.m_255043_(PalladiumConfiguredFeatures.ORE_LEAD), PalladiumPlacedFeatures.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)72))));
        PalladiumPlacedFeatures.register(context, UNDERGROUND_VIBRANIUM_METEORITE, configuredFeatures.m_255043_(PalladiumConfiguredFeatures.UNDERGROUND_VIBRANIUM_METEORITE), List.of(RarityFilter.m_191900_((int)24), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-164), (VerticalAnchor)VerticalAnchor.m_158930_((int)100))));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier placementModifier, PlacementModifier placementModifier2) {
        return List.of(placementModifier, InSquarePlacement.m_191715_(), placementModifier2, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier heightRange) {
        return PalladiumPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)count), heightRange);
    }

    private static List<PlacementModifier> rareOrePlacement(int chance, PlacementModifier heightRange) {
        return PalladiumPlacedFeatures.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)chance), heightRange);
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)Palladium.id(name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, PlacementModifier ... modifiers) {
        PalladiumPlacedFeatures.register(context, key, configuration, List.of(modifiers));
    }
}

