/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.world;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.scores.Objective;
import net.threetag.palladium.Palladium;
import net.threetag.palladiumcore.registry.ReloadListenerRegistry;
import net.threetag.palladiumcore.util.Platform;
import org.jetbrains.annotations.NotNull;

public class TrackedScoresManager
extends SimplePreparableReloadListener<List<String>> {
    public static TrackedScoresManager INSTANCE;
    private final List<String> tracked = new ArrayList<String>();

    public static void init() {
        INSTANCE = new TrackedScoresManager();
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (ResourceLocation)Palladium.id("tracked_scores"), (PreparableReloadListener)INSTANCE);
    }

    @NotNull
    protected List<String> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        ArrayList<String> objectives = new ArrayList<String>();
        profiler.m_7242_();
        for (String namespace : resourceManager.m_7187_()) {
            profiler.m_6180_(namespace);
            List list = resourceManager.m_213829_(new ResourceLocation(namespace, "tracked_scores.json"));
            for (Resource resource : list) {
                profiler.m_6180_(resource.m_215506_());
                try {
                    BufferedReader reader = resource.m_215508_();
                    profiler.m_6180_("parse");
                    JsonObject json = GsonHelper.m_13859_((Reader)reader);
                    JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"objectives");
                    for (JsonElement jsonElement : array) {
                        String obj = GsonHelper.m_13805_((JsonElement)jsonElement, (String)"objectives[]").trim();
                        if (objectives.contains(obj)) continue;
                        objectives.add(obj);
                    }
                    profiler.m_6182_("register");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        profiler.m_7241_();
        return objectives;
    }

    protected void apply(List<String> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        MinecraftServer server;
        this.tracked.clear();
        this.tracked.addAll(object);
        if (!this.tracked.isEmpty()) {
            Palladium.LOGGER.info("Registered " + this.tracked.size() + " objectives to be tracked");
        }
        if ((server = Platform.getCurrentServer()) != null) {
            for (String tracked : this.tracked) {
                ServerScoreboard scoreboard = server.m_129896_();
                Objective objective = scoreboard.m_83477_(tracked);
                if (objective == null) continue;
                scoreboard.m_136231_(objective);
            }
        }
    }

    public List<String> getTracked() {
        return this.tracked;
    }

    public boolean isTracked(String objective) {
        return this.tracked.contains(objective.trim());
    }
}

