/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.accessory;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.accessory.DefaultAccessory;
import net.threetag.palladium.addonpack.parser.AccessoryParser;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.PlayerUtil;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;

public class OverlayAccessory
extends DefaultAccessory {
    protected final TextureReference texture;
    protected final TextureReference textureSlim;
    protected boolean glowing = false;
    protected boolean onlyRenderSlot = false;
    protected boolean handVisibilityFix = false;

    public OverlayAccessory(TextureReference texture, TextureReference textureSlim) {
        this.texture = texture;
        this.textureSlim = textureSlim;
    }

    public OverlayAccessory(TextureReference texture) {
        this.texture = this.textureSlim = texture;
    }

    public OverlayAccessory(class_2960 texture, class_2960 textureSlim) {
        this(TextureReference.normal(texture), TextureReference.normal(textureSlim));
    }

    public OverlayAccessory(class_2960 texture) {
        this(TextureReference.normal(texture));
    }

    public OverlayAccessory(String texture, String textureSlim) {
        this(Palladium.id("textures/models/accessories/" + texture + ".png"), Palladium.id("textures/models/accessories/" + textureSlim + ".png"));
    }

    public OverlayAccessory(String texture) {
        this(Palladium.id("textures/models/accessories/" + texture + ".png"));
    }

    public OverlayAccessory glowing() {
        this.glowing = true;
        return this;
    }

    public OverlayAccessory onlyRenderSlot() {
        this.onlyRenderSlot = true;
        return this;
    }

    public OverlayAccessory handVisibilityFix() {
        this.handVisibilityFix = true;
        return this.onlyRenderSlot();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_3883<class_742, class_591<class_742>> renderLayerParent, AccessorySlot slot, class_4587 poseStack, class_4597 bufferSource, int packedLightIn, class_742 player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        class_1921 renderType;
        class_591 model = (class_591)renderLayerParent.method_4038();
        this.setVisibility((class_572<?>)model, player, slot);
        class_2960 texture = (PlayerUtil.hasSmallArms((class_1657)player) ? this.textureSlim : this.texture).getTexture(DataContext.forEntity((class_1297)player));
        class_1921 class_19212 = renderType = this.glowing ? class_1921.method_23026((class_2960)texture) : this.getRenderType(player, texture, (class_3879)renderLayerParent.method_4038());
        if (renderType == null) {
            return;
        }
        class_4588 buffer = bufferSource.getBuffer(renderType);
        model.method_2828(poseStack, buffer, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderArm(class_1306 arm, class_742 player, class_1007 playerRenderer, class_630 armPart, class_630 armWearPart, AccessorySlot slot, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        class_2960 texture = (PlayerUtil.hasSmallArms((class_1657)player) ? this.textureSlim : this.texture).getTexture(DataContext.forEntity((class_1297)player));
        class_4588 buffer = bufferSource.getBuffer(this.glowing ? class_1921.method_23026((class_2960)texture) : Objects.requireNonNull(this.getRenderType(player, texture, (class_3879)playerRenderer.method_4038())));
        armPart.field_3654 = 0.0f;
        armPart.field_3665 = true;
        armPart.method_22698(poseStack, buffer, packedLight, class_4608.field_21444);
        armWearPart.field_3654 = 0.0f;
        armWearPart.field_3665 = true;
        armWearPart.method_22698(poseStack, buffer, packedLight, class_4608.field_21444);
    }

    @Environment(value=EnvType.CLIENT)
    public void setVisibility(class_572<?> model, class_742 player, AccessorySlot slot) {
        if (this.onlyRenderSlot) {
            model.method_2805(false);
            slot.getHiddenBodyParts((class_1657)player).forEach(p -> p.setVisibility(model, true));
            if (this.handVisibilityFix) {
                if (slot == AccessorySlot.MAIN_HAND) {
                    AccessorySlot.MAIN_ARM.getHiddenBodyParts((class_1657)player).forEach(p -> p.setVisibility(model, true));
                } else if (slot == AccessorySlot.OFF_HAND) {
                    AccessorySlot.OFF_ARM.getHiddenBodyParts((class_1657)player).forEach(p -> p.setVisibility(model, true));
                }
            }
        } else {
            model.method_2805(true);
        }
    }

    public static class Serializer
    implements AccessoryParser.TypeSerializer {
        @Override
        public DefaultAccessory parse(JsonObject json) {
            SkinTypedValue<TextureReference> texture = SkinTypedValue.fromJSON(json.get("texture"), j -> TextureReference.parse(j.getAsString()));
            OverlayAccessory accessory = new OverlayAccessory(texture.getNormal(), texture.getSlim());
            if (class_3518.method_15258((JsonObject)json, (String)"glowing", (boolean)false)) {
                accessory.glowing();
            }
            if (class_3518.method_15258((JsonObject)json, (String)"only_render_for_slot", (boolean)false)) {
                accessory.onlyRenderSlot();
            }
            if (class_3518.method_15258((JsonObject)json, (String)"hand_visibility_fix", (boolean)false)) {
                accessory.handVisibilityFix();
            }
            return accessory;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Overlay");
            builder.setDescription("Renders a texture skin-tight on the player");
            builder.addProperty("texture", TextureReference.class).description("Texture of the overlay. Can be skin-typed by specifying 'normal' and 'slim' in a json object.").required().exampleJson((JsonElement)new JsonPrimitive("example:textures/accessory/test.png"));
            builder.addProperty("glowing", Boolean.class).description("Makes the overlay glow").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            builder.addProperty("only_render_for_slot", Boolean.class).description("If set to true, the texture will only render for the specified slot of the accessory. Example: The texture has a full player skin and the slot is set to 'head', only the head part of it will render.").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            builder.addProperty("hand_visibility_fix", Boolean.class).description("If 'only_render_for_slot' is set to true while the slot is for a hand but you want to have the accessory on the arm, set this to true.").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            AccessoryParser.addSlotDocumentation(builder);
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("overlay");
        }
    }
}

