/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.entity.BasicItemListing;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.event.LifecycleEvents;
import net.threetag.palladiumcore.registry.VillagerTradeRegistry;

public class VillagerTradeParser
extends class_4309 {
    private Map<class_2960, JsonObject> trades = ImmutableMap.of();

    public VillagerTradeParser() {
        super(AddonParser.GSON, "villager_trades");
        LifecycleEvents.SETUP.register(() -> {
            for (JsonObject json : this.trades.values()) {
                class_2960 profId = GsonUtil.getAsResourceLocation(json, "villager_profession");
                ArrayList listings = new ArrayList();
                GsonUtil.forEachInListOrPrimitive(json.get("trades"), el -> {
                    JsonObject tradeJson = class_3518.method_15295((JsonElement)el, (String)"trades");
                    listings.add(VillagerTradeParser.parseListing(tradeJson));
                });
                if (profId.toString().equals("minecraft:wandering_trader")) {
                    boolean rare = class_3518.method_15258((JsonObject)json, (String)"rare", (boolean)false);
                    VillagerTradeRegistry.registerForWanderingTrader((boolean)rare, (class_3853.class_1652[])listings.toArray(new BasicItemListing[0]));
                    continue;
                }
                if (class_7923.field_41195.method_10250(profId)) {
                    VillagerTradeRegistry.registerForProfession((class_3852)((class_3852)class_7923.field_41195.method_10223(profId)), (int)GsonUtil.getAsIntMin(json, "level", 1), (class_3853.class_1652[])listings.toArray(new BasicItemListing[0]));
                    continue;
                }
                throw new JsonParseException("Unknown villager profession " + String.valueOf(profId));
            }
        });
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        object.forEach((id, jsonElement) -> {
            JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)"top element");
            builder.put(id, (Object)json);
        });
        this.trades = builder.build();
    }

    public static BasicItemListing parseListing(JsonObject json) {
        class_1799 price = GsonUtil.getAsItemStack(json, "price");
        class_1799 price2 = GsonUtil.getAsItemStack(json, "price_2", class_1799.field_8037);
        class_1799 forSale = GsonUtil.getAsItemStack(json, "for_sale");
        int maxTrades = GsonUtil.getAsIntMin(json, "max_trades", 1);
        int xp = GsonUtil.getAsIntMin(json, "max_trades", 0);
        float priceMult = class_3518.method_15277((JsonObject)json, (String)"price_multiplier", (float)1.0f);
        return new BasicItemListing(price, price2, forSale, maxTrades, xp, priceMult);
    }
}

