/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.energybeam;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.threetag.palladium.client.energybeam.EnergyBeam;

public class EnergyBeamConfiguration {
    private final List<EnergyBeam> beams;

    public EnergyBeamConfiguration(List<EnergyBeam> energyBeams) {
        this.beams = energyBeams;
    }

    public void render(class_742 player, class_243 anchor, class_243 target, float lengthMultiplier, class_4587 poseStack, class_4597 bufferSource, int packedLightIn, boolean isFirstPerson, float partialTick) {
        for (EnergyBeam beam : this.beams) {
            beam.render(player, anchor, target, lengthMultiplier, poseStack, bufferSource, packedLightIn, isFirstPerson, partialTick);
        }
    }

    public void spawnParticles(class_1937 level, class_243 pos) {
        for (EnergyBeam beam : this.beams) {
            beam.spawnParticles(level, pos);
        }
    }

    public static EnergyBeamConfiguration fromJson(JsonElement json) {
        if (json.isJsonArray()) {
            ArrayList<EnergyBeam> beamList = new ArrayList<EnergyBeam>();
            JsonArray array = json.getAsJsonArray();
            for (JsonElement jsonElement : array) {
                beamList.add(EnergyBeam.fromJson(class_3518.method_15295((JsonElement)jsonElement, (String)"$[]")));
            }
            return new EnergyBeamConfiguration(beamList);
        }
        if (json.isJsonObject()) {
            return new EnergyBeamConfiguration(Collections.singletonList(EnergyBeam.fromJson(json.getAsJsonObject())));
        }
        throw new JsonSyntaxException("Energy beam configuration must be either an object or array of multiple objects");
    }
}

