/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.energybeam;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.energybeam.EnergyBeamRenderer;
import net.threetag.palladium.client.renderer.LaserRenderer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.PerspectiveValue;
import net.threetag.palladium.util.SizeUtil;
import net.threetag.palladium.util.context.DataContext;
import org.joml.Vector2f;

public class LaserBeamRenderer
extends EnergyBeamRenderer {
    private final LaserRenderer laserRenderer;
    private final PerspectiveValue<Boolean> visibility;

    public LaserBeamRenderer(LaserRenderer laserRenderer, PerspectiveValue<Boolean> visibility) {
        this.laserRenderer = laserRenderer;
        this.visibility = visibility;
    }

    @Override
    public void render(class_742 player, class_243 origin, class_243 target, float lengthMultiplier, class_4587 poseStack, class_4597 bufferSource, int packedLightIn, boolean isFirstPerson, float partialTick) {
        if (this.visibility.getForPlayer((class_1657)player).booleanValue()) {
            Vector2f size = this.laserRenderer.getSize();
            this.laserRenderer.size(size.mul(SizeUtil.getInstance().getModelWidthScale((class_1297)player, partialTick), SizeUtil.getInstance().getModelHeightScale((class_1297)player, partialTick), new Vector2f())).length((float)origin.method_1022(target) * lengthMultiplier).faceAndRender(DataContext.forEntity((class_1297)player), poseStack, bufferSource, origin, target, player.field_6012, partialTick);
            this.laserRenderer.size(size);
        }
    }

    public static class Serializer
    extends EnergyBeamRenderer.Serializer {
        public static final class_2960 ID = Palladium.id("laser");

        @Override
        public EnergyBeamRenderer fromJson(JsonObject json) {
            return new LaserBeamRenderer(LaserRenderer.fromJson(json), PerspectiveValue.getFromJson(json, "visibility", JsonElement::getAsBoolean, true));
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Laser");
            LaserRenderer.generateDocumentation(builder, 2, false);
            JsonObject exampleJson = new JsonObject();
            exampleJson.addProperty("first_person", Boolean.valueOf(true));
            exampleJson.addProperty("third_person", Boolean.valueOf(true));
            builder.addProperty("visibility", Boolean.class).description("Determines if its visible.").fallback(true).exampleJson((JsonElement)exampleJson);
        }

        @Override
        public class_2960 getId() {
            return ID;
        }
    }
}

