/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.model.animation;

import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.AnimationTimer;
import net.threetag.palladium.util.Easing;

public class AnimationUtil {
    public static float ease(Easing ease, float value) {
        return ease.apply(value);
    }

    public static float getAnimationTimerAbilityValue(class_1309 entity, class_2960 powerId, String abilityKey, float partialTicks) {
        Ability ability;
        AbilityInstance entry = AbilityUtil.getEntry(entity, powerId, abilityKey);
        if (entry != null && (ability = entry.getConfiguration().getAbility()) instanceof AnimationTimer) {
            AnimationTimer timer = (AnimationTimer)((Object)ability);
            return timer.getAnimationValue(entry, partialTicks);
        }
        return 0.0f;
    }

    public static float getAnimationTimerAbilityValue(class_1309 entity, class_2960 powerId, String abilityKey, float partialTicks, float start, float end) {
        Ability ability;
        AbilityInstance entry = AbilityUtil.getEntry(entity, powerId, abilityKey);
        if (entry != null && (ability = entry.getConfiguration().getAbility()) instanceof AnimationTimer) {
            AnimationTimer timer = (AnimationTimer)((Object)ability);
            float val = timer.getAnimationTimer(entry, partialTicks);
            return AnimationUtil.getInbetweenProgress(val, start, end);
        }
        return 0.0f;
    }

    public static float getInbetweenProgress(float progress, float startingPoint, float endPoint) {
        float shiftedEnd = endPoint - startingPoint;
        float shifted = class_3532.method_15363((float)(progress - startingPoint), (float)0.0f, (float)shiftedEnd);
        return shifted / shiftedEnd;
    }
}

