/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.model.animation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1007;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_4587;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.threetag.palladium.client.model.animation.PalladiumAnimation;
import net.threetag.palladium.event.PalladiumClientEvents;

@Environment(value=EnvType.CLIENT)
public class PalladiumAnimationRegistry
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<class_2960, PalladiumAnimation> animations = new LinkedHashMap<class_2960, PalladiumAnimation>();
    private final List<PalladiumAnimation> animationsSorted = new LinkedList<PalladiumAnimation>();
    public static boolean SKIP_ANIMATIONS = false;
    public static final PalladiumAnimationRegistry INSTANCE = new PalladiumAnimationRegistry();

    public PalladiumAnimationRegistry() {
        super(GSON, "palladium/animations");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        this.animations.clear();
        this.animationsSorted.clear();
        ((PalladiumClientEvents.RegisterAnimations)PalladiumClientEvents.REGISTER_ANIMATIONS.invoker()).register(this::registerAnimation);
        this.animationsSorted.addAll(this.animations.values());
        this.animationsSorted.sort(Comparator.comparingInt(PalladiumAnimation::getPriority));
    }

    public void registerAnimation(class_2960 id, PalladiumAnimation animation) {
        this.animations.put(id, animation);
    }

    public static void resetPoses(Iterable<class_630> headParts, Iterable<class_630> bodyParts) {
        for (class_630 bodyPart : headParts) {
            bodyPart.method_41923();
        }
        for (class_630 bodyPart : bodyParts) {
            bodyPart.method_41923();
        }
    }

    public static void forEach(class_742 player, class_572<?> model, PalladiumAnimation.FirstPersonContext firstPersonContext, float partialTicks, BiConsumer<PalladiumAnimation.PlayerModelPart, PalladiumAnimation.PartAnimationData> consumer) {
        HashMap gathered = new HashMap();
        for (PalladiumAnimation animation : PalladiumAnimationRegistry.INSTANCE.animationsSorted) {
            PalladiumAnimation.Builder builder = new PalladiumAnimation.Builder();
            animation.animate(builder, player, model, firstPersonContext, partialTicks);
            for (Map.Entry<PalladiumAnimation.PlayerModelPart, PalladiumAnimation.PartAnimationData> entry : builder.getAnimationData().entrySet()) {
                consumer.accept(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void forEach(class_742 player, class_572<?> model, PalladiumAnimation.FirstPersonContext firstPersonContext, float partialTicks, BiConsumer<PalladiumAnimation.PlayerModelPart, PalladiumAnimation.PartAnimationData> consumer, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        HashMap gathered = new HashMap();
        for (PalladiumAnimation animation : PalladiumAnimationRegistry.INSTANCE.animationsSorted) {
            PalladiumAnimation.Builder builder = new PalladiumAnimation.Builder(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            animation.animate(builder, player, model, firstPersonContext, partialTicks);
            for (Map.Entry<PalladiumAnimation.PlayerModelPart, PalladiumAnimation.PartAnimationData> entry : builder.getAnimationData().entrySet()) {
                consumer.accept(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void applyAnimations(class_572<?> model, class_1309 entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof class_742) {
            class_742 player = (class_742)entity;
            PalladiumAnimationRegistry.forEach(player, model, PalladiumAnimation.FirstPersonContext.NONE, class_310.method_1551().method_1488(), (part, data) -> part.applyToModelPart(model, (PalladiumAnimation.PartAnimationData)data), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public static void applyFirstPersonAnimations(class_4587 poseStack, class_742 player, class_572<?> model, boolean rightArm) {
        PalladiumAnimation.PoseStackResult result = new PalladiumAnimation.PoseStackResult();
        PalladiumAnimationRegistry.forEach(player, model, rightArm ? PalladiumAnimation.FirstPersonContext.RIGHT_ARM : PalladiumAnimation.FirstPersonContext.LEFT_ARM, class_310.method_1551().method_1488(), (part, data) -> {
            if (rightArm && part == PalladiumAnimation.PlayerModelPart.RIGHT_ARM) {
                data.apply(result);
            }
            if (!rightArm && part == PalladiumAnimation.PlayerModelPart.LEFT_ARM) {
                data.apply(result);
            }
        });
        result.apply(poseStack);
    }

    public static void setupRotations(class_1007 playerRenderer, class_742 player, class_4587 poseStack, float partialTicks) {
        PalladiumAnimation.PoseStackResult result = new PalladiumAnimation.PoseStackResult();
        PalladiumAnimationRegistry.forEach(player, (class_572)playerRenderer.method_4038(), PalladiumAnimation.FirstPersonContext.NONE, partialTicks, (part, data) -> {
            if (part == PalladiumAnimation.PlayerModelPart.BODY) {
                data.apply(result);
            }
        });
        result.apply(poseStack);
    }
}

