/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.awt.Color;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.RenderUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class LaserRenderer {
    private DynamicColor glowColor;
    private DynamicColor coreColor = DynamicColor.staticColor(Color.WHITE);
    private float rainbow = 0.0f;
    private float glowOpacity = 1.0f;
    private float coreOpacity = 1.0f;
    private int bloom = 3;
    private Vector2f size = new Vector2f(0.0625f, 0.0625f);
    private float length = 1.0f;
    private boolean normalTransparency = false;
    private float rotation = 0.0f;
    private float rotationSpeed = 0.0f;
    private float opacityAndSizeModifier = 1.0f;

    public LaserRenderer(DynamicColor color) {
        this.glowColor = color;
    }

    public LaserRenderer(DynamicColor glowColor, DynamicColor coreColor) {
        this.glowColor = glowColor;
        this.coreColor = coreColor;
    }

    public LaserRenderer color(DynamicColor color) {
        this.glowColor = color;
        return this;
    }

    public LaserRenderer color(DynamicColor glowColor, DynamicColor coreColor) {
        this.glowColor = glowColor;
        this.coreColor = coreColor;
        return this;
    }

    public DynamicColor getCoreColor() {
        return this.coreColor;
    }

    public DynamicColor getGlowColor() {
        return this.glowColor;
    }

    public LaserRenderer enableRainbow(float speed) {
        this.rainbow = speed;
        return this;
    }

    public float getRainbowSpeed() {
        return this.rainbow;
    }

    public LaserRenderer opacity(float opacity) {
        this.glowOpacity = this.coreOpacity = opacity;
        return this;
    }

    public LaserRenderer opacity(float glowOpacity, float coreOpacity) {
        this.glowOpacity = glowOpacity;
        this.coreOpacity = coreOpacity;
        return this;
    }

    public float getCoreOpacity() {
        return this.coreOpacity;
    }

    public float getGlowOpacity() {
        return this.glowOpacity;
    }

    public LaserRenderer bloom(int bloom) {
        this.bloom = class_3532.method_15340((int)bloom, (int)0, (int)10);
        return this;
    }

    public int getBloom() {
        return this.bloom;
    }

    public LaserRenderer size(float size) {
        return this.size(size, size);
    }

    public LaserRenderer size(float width, float height) {
        this.size = new Vector2f(width, height);
        return this;
    }

    public LaserRenderer size(Vector2f size) {
        this.size = size;
        return this;
    }

    public Vector2f getSize() {
        return this.size;
    }

    public LaserRenderer length(float length) {
        this.length = length;
        return this;
    }

    public float getLength() {
        return this.length;
    }

    public LaserRenderer normalTransparency() {
        this.normalTransparency = true;
        return this;
    }

    public LaserRenderer normalTransparency(boolean normalTransparency) {
        this.normalTransparency = normalTransparency;
        return this;
    }

    public boolean hasNormalTransparency() {
        return this.normalTransparency;
    }

    public LaserRenderer rotate(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public float getRotation() {
        return this.rotation;
    }

    public LaserRenderer rotationSpeed(float rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        return this;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public LaserRenderer opacityAndSizeModifier(float modifier) {
        this.opacityAndSizeModifier = modifier;
        return this;
    }

    public void face(class_4587 poseStack, class_243 origin, class_243 target) {
        RenderUtil.faceVec(poseStack, origin, target);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
    }

    public void faceAndRender(DataContext context, class_4587 poseStack, class_4597 bufferSource, class_243 origin, class_243 target, int ticks, float partialTick) {
        poseStack.method_22903();
        this.face(poseStack, origin, target);
        this.render(context, poseStack, bufferSource, ticks, partialTick);
        poseStack.method_22909();
    }

    public void render(DataContext context, class_4587 poseStack, class_4597 bufferSource, int ticks, float partialTick) {
        float rot = this.rotation;
        if (this.rotationSpeed > 0.0f) {
            rot += ((float)ticks + partialTick) * this.rotationSpeed;
        }
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(rot % 360.0f));
        class_4588 consumer = bufferSource.getBuffer(this.normalTransparency ? PalladiumRenderTypes.LASER_NORMAL_TRANSPARENCY : PalladiumRenderTypes.LASER);
        Vector2f size = new Vector2f((Vector2fc)this.size).mul(this.opacityAndSizeModifier);
        class_238 box = new class_238((double)(-size.x / 2.0f), 0.0, (double)(-size.y / 2.0f), (double)(size.x / 2.0f), (double)this.length, (double)(size.y / 2.0f));
        if (this.coreOpacity > 0.0f) {
            Color coreColor = this.coreColor.getColor(context);
            RenderUtil.renderFilledBox(poseStack, consumer, box, (float)coreColor.getRed() / 255.0f, (float)coreColor.getGreen() / 255.0f, (float)coreColor.getBlue() / 255.0f, this.coreOpacity * this.opacityAndSizeModifier, 0xF00000);
        }
        Color glowColor = this.getRenderedGlowColor(context, ticks, partialTick);
        float r = (float)glowColor.getRed() / 255.0f;
        float g = (float)glowColor.getGreen() / 255.0f;
        float b = (float)glowColor.getBlue() / 255.0f;
        if (this.glowOpacity > 0.0f) {
            for (int i = 0; i < this.bloom + 1; ++i) {
                RenderUtil.renderFilledBox(poseStack, consumer, box.method_1014((double)((float)i * 0.5f * 0.0625f)), r, g, b, 1.0f / (float)i / 2.0f * this.glowOpacity * this.opacityAndSizeModifier, 0xF00000);
            }
        }
        poseStack.method_22909();
    }

    private Color getRenderedGlowColor(DataContext context, int ticks, float partialTick) {
        if (this.rainbow > 0.0f) {
            int rate = Math.max((int)(25.0f * (1.0f - this.rainbow)), 1);
            int j = ticks / rate;
            int k = class_1767.values().length;
            int l = j % k;
            int m = (j + 1) % k;
            float f = ((float)(ticks % rate) + partialTick) / (float)rate;
            float[] fs = class_1472.method_6634((class_1767)class_1767.method_7791((int)l));
            float[] gs = class_1472.method_6634((class_1767)class_1767.method_7791((int)m));
            return new Color(fs[0] * (1.0f - f) + gs[0] * f, fs[1] * (1.0f - f) + gs[1] * f, fs[2] * (1.0f - f) + gs[2] * f);
        }
        return this.glowColor.getColor(context);
    }

    public static LaserRenderer fromJson(JsonObject json) {
        return LaserRenderer.fromJson(json, 2);
    }

    public static LaserRenderer fromJson(JsonObject json, int defaultBloom) {
        LaserRenderer laser = new LaserRenderer(DynamicColor.getFromJson(json, "glow_color", DynamicColor.WHITE), DynamicColor.getFromJson(json, "core_color", DynamicColor.WHITE)).enableRainbow(GsonUtil.getAsBooleanFloat(json, "rainbow", 0.0f)).opacity(GsonUtil.getAsFloatRanged(json, "glow_opacity", 0.0f, 1.0f, 1.0f), GsonUtil.getAsFloatRanged(json, "core_opacity", 0.0f, 1.0f, 1.0f)).bloom(GsonUtil.getAsIntRanged(json, "bloom", 0, 10, defaultBloom)).size(LaserRenderer.parseSize(json, "size", new Vector2f(1.0f, 1.0f)).mul(0.0625f)).length(GsonUtil.getAsFloatMin(json, "length", 0.0f, 1.0f) / 16.0f).normalTransparency(class_3518.method_15258((JsonObject)json, (String)"normal_transparency", (boolean)false)).rotate(GsonUtil.getAsFloatMin(json, "rotation", 0.0f, 0.0f)).rotationSpeed(GsonUtil.getAsFloatMin(json, "rotation_speed", 0.0f, 0.0f));
        if (json.has("thickness")) {
            laser.size(GsonUtil.getAsFloatMin(json, "thickness", 0.0f, 0.05f) * 20.0f / 16.0f);
        }
        return laser;
    }

    private static Vector2f parseSize(JsonObject json, String memberName, Vector2f fallback) {
        if (json.has(memberName)) {
            JsonElement el = json.get(memberName);
            if (el.isJsonPrimitive()) {
                float val = class_3518.method_15269((JsonElement)el, (String)memberName);
                return new Vector2f(val, val);
            }
            if (el.isJsonArray()) {
                JsonArray array = el.getAsJsonArray();
                if (array.size() != 2) {
                    throw new JsonSyntaxException("Size must be an array of 2 numbers");
                }
                return new Vector2f(array.get(0).getAsFloat(), array.get(1).getAsFloat());
            }
            throw new JsonSyntaxException(memberName + " must be a simple number or an array of 2");
        }
        return fallback;
    }

    public static void generateDocumentation(JsonDocumentationBuilder builder, int defaultBloom, boolean withLength) {
        builder.addProperty("glow_color", Color.class).description("Color of the laser glow").fallback(Color.WHITE).exampleJson((JsonElement)new JsonPrimitive("#ffffff"));
        builder.addProperty("core_color", Color.class).description("Color of the inner core").fallback(Color.WHITE).exampleJson((JsonElement)new JsonPrimitive("#ffffff"));
        builder.addProperty("rainbow", Boolean.class).description("If enabled, the glow will have a rainbow effect. Can also be defined as a float to determine the speed").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        builder.addProperty("glow_opacity", Float.class).description("Opacity for the laser glow").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
        builder.addProperty("core_opacity", Float.class).description("Opacity for the inner core").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
        builder.addProperty("bloom", Integer.class).description("Describes how many stages of \"bloom\" is visible as the glow").fallback(defaultBloom).exampleJson((JsonElement)new JsonPrimitive((Number)defaultBloom));
        builder.addProperty("size", Vector2f.class).description("Size of the laser. Can either be defined as a simple float (e.g. 1.0), or 2-dimensional using an array (e.g. [1.0, 2.0])").fallback(new Vector2f(1.0f, 1.0f), "[1.0, 1.0]").exampleJson((JsonElement)new JsonPrimitive((Number)1));
        if (withLength) {
            builder.addProperty("length", Float.class).description("Length of the laser").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)1));
        }
        builder.addProperty("normal_transparency", Boolean.class).description("You only ever really need to set it to true if you intend to make the core or glow black").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        builder.addProperty("rotation", Float.class).description("Rotation of the laser").fallback(Float.valueOf(0.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(0.0f)));
        builder.addProperty("rotation_speed", Float.class).description("Speed at which the laser rotates").fallback(Float.valueOf(0.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(0.0f)));
    }
}

