/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.util.Easing;
import net.threetag.palladiumcore.event.ClientTickEvents;
import org.joml.Matrix4f;

public class WatcherRenderer
implements ClientTickEvents.ClientLevelTick {
    public static final WatcherRenderer INSTANCE = new WatcherRenderer();
    private static final class_2960 TEXTURE = Palladium.id("textures/environment/watcher.png");
    private static final int OCCURRENCE_INTERVAL = 24000;
    private static final float OCCURRENCE_CHANCE = 0.01f;
    private static final int OCCURRENCE_DURATION = 1200;
    private static final int OCCURRENCE_FADE = 40;
    private int ticksTilOccurrence = 24000;
    private int visibleTicks = 0;
    private int visibility = 0;
    private int prevVisibility = 0;

    public static void init() {
        ClientTickEvents.CLIENT_LEVEL_POST.register((Object)INSTANCE);
    }

    public void render(class_4587 poseStack, float visibility) {
        if (visibility > 0.0f) {
            Easing easing = this.visibleTicks > 0 ? Easing.INSINE : Easing.OUTSINE;
            visibility = easing.apply(visibility);
            poseStack.method_22903();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-135.0f));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(60.0f));
            Matrix4f matrix4f2 = poseStack.method_23760().method_23761();
            float f = 40.0f;
            float g = 100.0f;
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)visibility);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(matrix4f2, -f, g, -f).method_22913(1.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix4f2, f, g, -f).method_22913(0.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(matrix4f2, f, g, f).method_22913(0.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(matrix4f2, -f, g, f).method_22913(1.0f, 1.0f).method_1344();
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.method_22909();
        }
    }

    public void clientLevelTick(class_310 minecraft, class_638 clientLevel) {
        this.prevVisibility = this.visibility;
        if (this.ticksTilOccurrence > 0) {
            --this.ticksTilOccurrence;
            if (this.ticksTilOccurrence <= 0) {
                if (Math.random() < (double)0.01f) {
                    this.visibleTicks = 1200;
                }
                this.ticksTilOccurrence = (int)(24000.0 * (1.0 + Math.random()));
            }
        }
        if (this.visibleTicks > 0) {
            --this.visibleTicks;
            if (this.visibility < 40) {
                ++this.visibility;
            }
        } else if (this.visibility > 0) {
            --this.visibility;
        }
    }

    public float getVisibility(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.prevVisibility, (float)this.visibility) / 40.0f;
    }
}

