/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5601;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.client.dynamictexture.DynamicModelLayerLocation;
import net.threetag.palladium.client.dynamictexture.DynamicTexture;
import net.threetag.palladium.client.dynamictexture.DynamicTextureManager;
import net.threetag.palladium.client.model.ExtraAnimatedModel;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.renderlayer.AbstractPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.ModelTypes;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.client.renderer.renderlayer.RenderTypeFunction;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.FalseCondition;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;

public class PackRenderLayer
extends AbstractPackRenderLayer {
    private final SkinTypedValue<ModelTypes.Model> modelLookup;
    private final SkinTypedValue<ModelCache> model;
    private final SkinTypedValue<DynamicTexture> texture;
    private final RenderTypeFunction renderType;
    private final DynamicColor tint;
    private final List<Condition> enchantmentGlint;

    public PackRenderLayer(SkinTypedValue<ModelTypes.Model> model, SkinTypedValue<DynamicModelLayerLocation> modelLayerLocation, SkinTypedValue<DynamicTexture> texture, RenderTypeFunction renderType, DynamicColor tint, List<Condition> enchantmentGlint) {
        this.modelLookup = model;
        this.model = new SkinTypedValue<ModelCache>(new ModelCache(modelLayerLocation.getNormal()), new ModelCache(modelLayerLocation.getSlim()));
        this.texture = texture;
        this.renderType = renderType;
        this.tint = tint;
        this.enchantmentGlint = enchantmentGlint;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void render(DataContext context, class_4587 poseStack, class_4597 bufferSource, class_583<class_1297> parentModel, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        block4: {
            entity = context.getEntity();
            if (!IPackRenderLayer.conditionsFulfilled(entity, this.conditions, this.thirdPersonConditions) || !this.modelLookup.get(entity).fitsEntity(entity, parentModel)) break block4;
            entityModel = this.model.get(entity).getModel(context, this.modelLookup.get(entity));
            if (!(entityModel instanceof class_572)) ** GOTO lbl-1000
            entityHumanoidModel = (class_572)entityModel;
            if (parentModel instanceof class_572) {
                parentHumanoid = (class_572)parentModel;
                IPackRenderLayer.copyModelProperties(entity, parentHumanoid, entityHumanoidModel);
            } else lbl-1000:
            // 2 sources

            {
                entityModel.method_2816(entity, limbSwing, limbSwingAmount, partialTicks);
                entityModel.method_2819(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            }
            if (entityModel instanceof ExtraAnimatedModel) {
                extra = (ExtraAnimatedModel)entityModel;
                extra.extraAnimations(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, partialTicks);
            }
            vertexConsumer = this.renderType.createVertexConsumer(bufferSource, this.texture.get(entity).getTexture(context), context.getItem().method_7958() != false || IPackRenderLayer.conditionsFulfilled(entity, this.enchantmentGlint) != false);
            tint = Color.WHITE;
            if (this.tint != null) {
                tint = this.tint.getColor(context);
            }
            entityModel.method_2828(poseStack, vertexConsumer, this.renderType.getPackedLight(packedLight), class_4608.field_21444, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, (float)tint.getAlpha() / 255.0f);
        }
    }

    @Override
    public void renderArm(DataContext context, class_1306 arm, class_1007 playerRenderer, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        class_583<?> entityModel;
        class_1297 player = context.getEntity();
        if (IPackRenderLayer.conditionsFulfilled(player, this.conditions, this.firstPersonConditions) && this.modelLookup.get(player).fitsEntity(player, playerRenderer.method_4038()) && (entityModel = this.model.get(player).getModel(context, this.modelLookup.get(player))) instanceof class_572) {
            class_572 humanoidModel = (class_572)entityModel;
            ((class_591)playerRenderer.method_4038()).method_2818(humanoidModel);
            class_4588 vertexConsumer = this.renderType.createVertexConsumer(bufferSource, this.texture.get(player).getTexture(context), context.getItem().method_7958() || IPackRenderLayer.conditionsFulfilled(player, this.enchantmentGlint));
            humanoidModel.field_3447 = 0.0f;
            humanoidModel.field_3400 = false;
            humanoidModel.field_3396 = 0.0f;
            Color tint = Color.WHITE;
            if (this.tint != null) {
                tint = this.tint.getColor(context);
            }
            if (arm == class_1306.field_6183) {
                humanoidModel.field_3401.field_3654 = 0.0f;
                humanoidModel.field_3401.method_22699(poseStack, vertexConsumer, this.renderType.getPackedLight(packedLight), class_4608.field_21444, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, (float)tint.getAlpha() / 255.0f);
            } else {
                humanoidModel.field_27433.field_3654 = 0.0f;
                humanoidModel.field_27433.method_22699(poseStack, vertexConsumer, this.renderType.getPackedLight(packedLight), class_4608.field_21444, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, (float)tint.getAlpha() / 255.0f);
            }
        }
    }

    @Override
    public void createSnapshot(DataContext context, class_583<class_1297> parentModel, Consumer<IPackRenderLayer.Snapshot> consumer) {
        class_1297 entity = context.getEntity();
        if (IPackRenderLayer.conditionsFulfilled(entity, this.conditions, this.firstPersonConditions) && this.modelLookup.get(entity).fitsEntity(entity, parentModel)) {
            class_583<?> entityModel = this.model.get(entity).getModel(context, this.modelLookup.get(entity));
            class_2960 texture = this.texture.get(entity).getTexture(context);
            consumer.accept(new IPackRenderLayer.Snapshot(entityModel, texture));
        }
    }

    public static PackRenderLayer parse(JsonObject json) {
        RenderTypeFunction renderType = PackRenderLayerManager.getRenderType(new class_2960(class_3518.method_15253((JsonObject)json, (String)"render_type", (String)"solid")));
        String modelTypeKey = "model_type";
        if (!json.has(modelTypeKey) && json.has("model")) {
            AddonPackLog.warning("Deprecated use of 'model' in render layer. Please switch to 'model_type'!", new Object[0]);
            modelTypeKey = "model";
        }
        SkinTypedValue<ModelTypes.Model> model = class_3518.method_15294((JsonObject)json, (String)modelTypeKey) ? SkinTypedValue.fromJSON(json.get(modelTypeKey), jsonElement -> {
            class_2960 modelId = new class_2960(jsonElement.getAsString());
            ModelTypes.Model m = ModelTypes.get(modelId);
            if (m == null) {
                throw new JsonParseException("Unknown model type '" + String.valueOf(modelId) + "'");
            }
            return m;
        }) : new SkinTypedValue<ModelTypes.Model>(ModelTypes.HUMANOID);
        if (renderType == null) {
            throw new JsonParseException("Unknown render type '" + String.valueOf(new class_2960(class_3518.method_15253((JsonObject)json, (String)"render_type", (String)"solid"))) + "'");
        }
        List<Condition> enchantmentGlint = json.has("enchantment_glint") ? ConditionSerializer.listFromJSON(json.get("enchantment_glint"), ConditionEnvironment.ASSETS) : Collections.singletonList(new FalseCondition());
        return new PackRenderLayer(model, SkinTypedValue.fromJSON(json.get("model_layer"), DynamicModelLayerLocation::fromJson), SkinTypedValue.fromJSON(json.get("texture"), DynamicTextureManager::fromJson), renderType, DynamicColor.getFromJson(json, "tint", null), enchantmentGlint);
    }

    public static class ModelCache {
        private final DynamicModelLayerLocation modelLayerLocation;
        private final Map<class_5601, class_583<?>> models = new HashMap();

        public ModelCache(DynamicModelLayerLocation modelLayerLocation) {
            this.modelLayerLocation = modelLayerLocation;
        }

        public class_583<?> getModel(DataContext context, ModelTypes.Model modelType) {
            class_5601 modelLayer = this.modelLayerLocation.getModelLayer(context);
            if (this.models.containsKey(modelLayer)) {
                return this.models.get(modelLayer);
            }
            class_583<?> model = modelType.getModel(class_310.method_1551().method_31974().method_32072(modelLayer));
            this.models.put(modelLayer, model);
            return model;
        }
    }
}

