/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.trail;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.LaserRenderer;
import net.threetag.palladium.client.renderer.entity.TrailSegmentEntityRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRendererManager;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.entity.PalladiumEntityExtension;
import net.threetag.palladium.entity.TrailSegmentEntity;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;

public class LightningTrailRenderer
extends TrailRenderer<Cache> {
    private final LaserRenderer laserRenderer;
    private final float spacing;
    private final int lifetime;
    private final int amount;
    private final float spreadX;
    private final float spreadY;

    public LightningTrailRenderer(LaserRenderer laserRenderer, float spacing, int lifetime, int amount, float spreadX, float spreadY) {
        this.laserRenderer = laserRenderer;
        this.spacing = spacing;
        this.lifetime = lifetime;
        this.amount = amount;
        this.spreadX = spreadX;
        this.spreadY = spreadY;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, TrailSegmentEntityRenderer trailRenderer, class_1297 livingEntity, TrailSegmentEntity<Cache> segment, float partialTick, float entityYaw) {
        PalladiumEntityExtension ext;
        List<TrailSegmentEntity<?>> trails;
        int index;
        if (livingEntity instanceof PalladiumEntityExtension && (index = (trails = (ext = (PalladiumEntityExtension)livingEntity).palladium$getTrailHandler().getTrails().get(this)).indexOf(segment)) == trails.size() - 1) {
            this.renderSegmentWithChild(DataContext.forEntity(livingEntity), poseStack, buffer, segment, trails, partialTick, index);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void renderSegmentWithChild(DataContext context, class_4587 poseStack, class_4597 buffer, TrailSegmentEntity<Cache> segment, List<TrailSegmentEntity<?>> segments, float partialTick, int index) {
        if (index > 0) {
            TrailSegmentEntity<Cache> previousSegment = segments.get(index - 1);
            Cache cache = (Cache)segment.cache;
            Object previousC = previousSegment.cache;
            if (index == segments.size() - 1 && segment.parent.method_5805()) {
                for (int i = 0; i < cache.offsets.length; ++i) {
                    class_243 start = LightningTrailRenderer.getOffsetPos(segment, cache.offsets[i]);
                    class_243 end = LightningTrailRenderer.getOffsetPos(segment.parent, cache.offsets[i]).method_1019(segment.parent.method_30950(partialTick).method_1020(segment.method_19538()));
                    float opacity = 1.0f - ((float)segment.field_6012 + partialTick) / (float)segment.lifetime;
                    poseStack.method_22903();
                    poseStack.method_22904(start.field_1352, start.field_1351, start.field_1350);
                    this.laserRenderer.length((float)start.method_1022(end)).opacityAndSizeModifier(opacity).faceAndRender(context, poseStack, buffer, start, end, segment.parent.field_6012 + i * 42, partialTick);
                    poseStack.method_22909();
                }
            }
            if (previousC instanceof Cache) {
                Cache previousCache = (Cache)previousC;
                if (cache.offsets.length == previousCache.offsets.length && previousSegment.method_5805()) {
                    for (int i = 0; i < cache.offsets.length; ++i) {
                        class_243 start = LightningTrailRenderer.getOffsetPos(segment, cache.offsets[i]);
                        class_243 end = LightningTrailRenderer.getOffsetPos(previousSegment, previousCache.offsets[i]).method_1019(previousSegment.method_19538().method_1020(segment.method_19538()));
                        float opacity = 1.0f - ((float)segment.field_6012 + partialTick) / (float)segment.lifetime;
                        poseStack.method_22903();
                        poseStack.method_22904(start.field_1352, start.field_1351, start.field_1350);
                        this.laserRenderer.length((float)start.method_1022(end)).opacityAndSizeModifier(opacity).faceAndRender(context, poseStack, buffer, start, end, segment.parent.field_6012 + i * 42, partialTick);
                        poseStack.method_22909();
                    }
                    poseStack.method_22903();
                    class_243 offsetPos = previousSegment.method_19538().method_1020(segment.method_19538());
                    poseStack.method_22904(offsetPos.field_1352, offsetPos.field_1351, offsetPos.field_1350);
                    this.renderSegmentWithChild(context, poseStack, buffer, previousSegment, segments, partialTick, index - 1);
                    poseStack.method_22909();
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class_243 getOffsetPos(class_1297 segment, class_243 offset) {
        return new class_243(offset.field_1352 * (double)segment.method_17681(), (double)segment.method_17682() / 2.0 + offset.field_1351 * (double)segment.method_17682(), offset.field_1350 * (double)segment.method_17681());
    }

    @Override
    public TrailRenderer.SegmentCache createCache() {
        Random random = new Random();
        class_243[] offsets = new class_243[this.amount];
        for (int i = 0; i < this.amount; ++i) {
            double spacingY = 1.0 / (double)this.amount * (double)this.spreadY;
            offsets[i] = new class_243((random.nextDouble() - 0.5) * (double)this.spreadX, spacingY * (double)this.amount / -2.0 + spacingY * (double)i + spacingY / 2.0 + (random.nextDouble() - 0.5) * spacingY / 1.5, (random.nextDouble() - 0.5) * (double)this.spreadX);
        }
        return new Cache(offsets);
    }

    @Override
    public float getSpacing() {
        return this.spacing;
    }

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    @Override
    public DynamicColor getColor() {
        return this.laserRenderer.getGlowColor();
    }

    public static class Cache
    extends TrailRenderer.SegmentCache {
        private final class_243[] offsets;

        public Cache(class_243[] offsets) {
            this.offsets = offsets;
        }
    }

    public static class Serializer
    implements TrailRendererManager.TypeSerializer {
        public TrailRenderer<Cache> parse(JsonObject json) {
            float spacing = GsonUtil.getAsFloatMin(json, "spacing", 0.1f, 1.0f);
            int lifetime = GsonUtil.getAsIntMin(json, "lifetime", 1, 20);
            int amount = GsonUtil.getAsIntMin(json, "amount", 1, 10);
            float spreadX = GsonUtil.getAsFloatMin(json, "spread_x", 0.0f, 1.0f);
            float spreadY = GsonUtil.getAsFloatMin(json, "spread_y", 0.0f, 1.0f);
            return new LightningTrailRenderer(LaserRenderer.fromJson(json, 1), spacing, lifetime, amount, spreadX, spreadY);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Lightning Trail");
            builder.setDescription("Flash-like lightning trail");
            builder.addProperty("spacing", Float.class).description("Determines the space between two trail segments").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("lifetime", Integer.class).description("Determines how long one trail segment stays alive (in ticks)").fallback(20).exampleJson((JsonElement)new JsonPrimitive((Number)20));
            builder.addProperty("amount", Integer.class).description("Determines how many lightnings the entity will generate behind it").fallback(7).exampleJson((JsonElement)new JsonPrimitive((Number)7));
            builder.addProperty("spread_x", Float.class).description("Determines the spread of a lightning position relative to the player on the X/horizontal axis. 1 means across the normal player hitbox, 0 means always in the middle.").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("spread_y", Float.class).description("Determines the spread of a lightning position relative to the player on the Y/vertical axis. 1 means across the normal player hitbox, 0 means always in the middle.").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            LaserRenderer.generateDocumentation(builder, 1, false);
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("lightning");
        }
    }
}

