/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen.power;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_455;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.threetag.palladium.client.screen.power.PowersScreen;
import net.threetag.palladium.client.screen.power.TreePowerTab;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityDescription;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.context.DataContext;

public class TreeAbilityWidget {
    private static final int HEIGHT = 26;
    private static final int BOX_X = 0;
    private static final int BOX_WIDTH = 200;
    private static final int FRAME_WIDTH = 26;
    private static final int ICON_X = 8;
    private static final int ICON_Y = 5;
    private static final int ICON_WIDTH = 26;
    private static final int TITLE_PADDING_LEFT = 3;
    private static final int TITLE_PADDING_RIGHT = 5;
    private static final int TITLE_X = 32;
    private static final int TITLE_Y = 9;
    private static final int TITLE_MAX_WIDTH = 163;
    private static final int[] TEST_SPLIT_OFFSETS = new int[]{0, 10, -10, 25, -25};
    private final TreePowerTab tab;
    private final IPowerHolder holder;
    public final AbilityInstance abilityInstance;
    private final class_5481 title;
    private final int width;
    private final List<class_5481> description;
    private final class_310 minecraft;
    List<TreeAbilityWidget> parents = new LinkedList<TreeAbilityWidget>();
    List<TreeAbilityWidget> children = new LinkedList<TreeAbilityWidget>();
    private int x;
    private int y;
    public double gridX;
    public double gridY;
    public boolean fixedPosition = false;

    public TreeAbilityWidget(TreePowerTab tab, class_310 mc, IPowerHolder holder, AbilityInstance abilityInstance) {
        this.tab = tab;
        this.holder = holder;
        this.abilityInstance = abilityInstance;
        this.minecraft = mc;
        this.title = class_2477.method_10517().method_30934(mc.field_1772.method_1714((class_5348)abilityInstance.getConfiguration().getDisplayName(), 163));
        int l = 29 + mc.field_1772.method_30880(this.title);
        AbilityDescription description = abilityInstance.getProperty(Ability.DESCRIPTION);
        this.description = class_2477.method_10517().method_30933(this.findOptimalLines((class_2561)class_2564.method_10889((class_5250)(description != null ? description.get(this.abilityInstance.isUnlocked()).method_27661() : class_2561.method_43473()), (class_2583)class_2583.field_24360.method_10977(class_124.field_1068)), l));
        for (class_5481 formattedCharSequence : this.description) {
            l = Math.max(l, this.minecraft.field_1772.method_30880(formattedCharSequence));
        }
        this.width = l + 3 + 5;
    }

    public TreeAbilityWidget updatePosition(double x, double y, TreePowerTab tab) {
        this.gridX = x;
        this.gridY = y;
        this.x = (int)(x * 50.0) - 16;
        this.y = (int)(tab.getFreeYPos(x, y) * 50.0) - 13;
        for (TreeAbilityWidget child : this.children) {
            child.updatePosition(this.gridX + 1.0, y, tab);
        }
        return this;
    }

    public TreeAbilityWidget setPosition(double x, double y) {
        this.gridX = x;
        this.gridY = y;
        this.x = (int)(x * 50.0) - 16;
        this.y = (int)(y * 50.0) - 13;
        return this;
    }

    public TreeAbilityWidget setPositionFixed(double x, double y) {
        this.fixedPosition = true;
        return this.setPosition(x, y);
    }

    public TreeAbilityWidget updateRelatives(Collection<TreeAbilityWidget> list) {
        this.parents.clear();
        this.children.clear();
        List<AbilityInstance> parents = Ability.findParentsWithinHolder(this.abilityInstance.getConfiguration(), this.holder);
        List<AbilityInstance> children = Ability.findChildrenWithinHolder(this.abilityInstance.getConfiguration(), this.holder);
        for (TreeAbilityWidget widget : list) {
            if (!parents.isEmpty() && parents.contains(widget.abilityInstance)) {
                this.parents.add(widget);
            }
            if (children.isEmpty() || !children.contains(widget.abilityInstance)) continue;
            this.children.add(widget);
        }
        return this;
    }

    private static float getMaxWidth(class_5225 manager, List<class_5348> text) {
        return (float)text.stream().mapToDouble(arg_0 -> ((class_5225)manager).method_27488(arg_0)).max().orElse(0.0);
    }

    private List<class_5348> findOptimalLines(class_2561 component, int maxWidth) {
        class_5225 stringSplitter = this.minecraft.field_1772.method_27527();
        List list = null;
        float f = Float.MAX_VALUE;
        for (int i : TEST_SPLIT_OFFSETS) {
            List list2 = stringSplitter.method_27495((class_5348)component, maxWidth - i, class_2583.field_24360);
            float g = Math.abs(TreeAbilityWidget.getMaxWidth(stringSplitter, list2) - (float)maxWidth);
            if (g <= 10.0f) {
                return list2;
            }
            if (!(g < f)) continue;
            f = g;
            list = list2;
        }
        return list;
    }

    public void drawDisplayIcon(class_310 mc, class_332 guiGraphics, int x, int y) {
        if (this.abilityInstance.isUnlocked()) {
            this.abilityInstance.getProperty(Ability.ICON).draw(mc, guiGraphics, DataContext.forAbility((class_1309)mc.field_1724, this.abilityInstance), x, y);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.method_25302(PowersScreen.WIDGETS, x, y, 90, 83, 16, 16);
        }
    }

    public void drawIcon(class_310 mc, class_332 guiGraphics, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25302(PowersScreen.WIDGETS, x - 13, y - 13, 0, this.abilityInstance.isUnlocked() ? 78 : 104, 26, 26);
        this.drawDisplayIcon(mc, guiGraphics, x - 8, y - 8);
    }

    public int getWidth() {
        return this.width;
    }

    public void drawHover(class_332 guiGraphics, int x, int y, float fade, int width, int height) {
        class_455 advancementWidgetType3;
        class_455 advancementWidgetType2;
        class_455 advancementWidgetType;
        boolean bl = width + x + this.x + this.width + 26 >= this.tab.getScreen().field_22789;
        String string = null;
        int i = string == null ? 0 : this.minecraft.field_1772.method_1727(string);
        boolean bl2 = 113 - y - this.y - 26 <= 6 + this.description.size() * 9;
        float f = 0.0f;
        int j = class_3532.method_15375((float)(f * (float)this.width));
        if (f >= 1.0f) {
            j = this.width / 2;
            advancementWidgetType = class_455.field_2701;
            advancementWidgetType2 = class_455.field_2701;
            advancementWidgetType3 = class_455.field_2701;
        } else if (j < 2) {
            j = this.width / 2;
            advancementWidgetType = class_455.field_2699;
            advancementWidgetType2 = class_455.field_2699;
            advancementWidgetType3 = class_455.field_2699;
        } else if (j > this.width - 2) {
            j = this.width / 2;
            advancementWidgetType = class_455.field_2701;
            advancementWidgetType2 = class_455.field_2701;
            advancementWidgetType3 = class_455.field_2699;
        } else {
            advancementWidgetType = class_455.field_2701;
            advancementWidgetType2 = class_455.field_2699;
            advancementWidgetType3 = class_455.field_2699;
        }
        int k = this.width - j;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        int l = y + this.y;
        int m = bl ? x + this.x - this.width + 26 + 6 : x + this.x;
        int n = 32 + this.description.size() * 9;
        if (!this.description.isEmpty()) {
            if (bl2) {
                guiGraphics.method_48586(PowersScreen.WIDGETS, m, l + 26 - n, this.width, n, 10, 200, 26, 0, 52);
            } else {
                guiGraphics.method_48586(PowersScreen.WIDGETS, m, l, this.width, n, 10, 200, 26, 0, 52);
            }
        }
        guiGraphics.method_25302(PowersScreen.WIDGETS, m, l, 0, advancementWidgetType.method_2320() * 26, j, 26);
        guiGraphics.method_25302(PowersScreen.WIDGETS, m + j, l, 200 - k, advancementWidgetType2.method_2320() * 26, k, 26);
        guiGraphics.method_25302(PowersScreen.WIDGETS, x + this.x + 3, y + this.y, 0, 78 + advancementWidgetType3.method_2320() * 26, 26, 26);
        if (bl) {
            guiGraphics.method_35720(this.minecraft.field_1772, this.title, m + 5, y + this.y + 9, -1);
            if (string != null) {
                guiGraphics.method_25303(this.minecraft.field_1772, string, x + this.x - i, y + this.y + 9, -1);
            }
        } else {
            guiGraphics.method_35720(this.minecraft.field_1772, this.title, x + this.x + 32, y + this.y + 9, -1);
            if (string != null) {
                guiGraphics.method_25303(this.minecraft.field_1772, string, x + this.x + this.width - i - 5, y + this.y + 9, -1);
            }
        }
        if (bl2) {
            for (int o = 0; o < this.description.size(); ++o) {
                guiGraphics.method_35720(this.minecraft.field_1772, this.description.get(o), m + 5, l + 26 - n + 7 + o * 9, -5592406);
            }
        } else {
            for (int o = 0; o < this.description.size(); ++o) {
                guiGraphics.method_35720(this.minecraft.field_1772, this.description.get(o), m + 5, y + this.y + 9 + 17 + o * 9, -5592406);
            }
        }
        this.drawDisplayIcon(this.minecraft, guiGraphics, x + this.x + 8, y + this.y + 5);
    }

    public boolean isMouseOver(int x, int y, int mouseX, int mouseY) {
        int i = x + this.x;
        int j = i + 26;
        int k = y + this.y;
        int l = k + 26;
        return mouseX >= i && mouseX <= j && mouseY >= k && mouseY <= l;
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }
}

