/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2300;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.threetag.palladium.command.SuperpowerCommand;
import net.threetag.palladium.condition.BuyableCondition;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerHandler;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.power.ability.AbilityInstance;

public class AbilityCommand {
    private static final SuggestionProvider<class_2168> SUGGEST_OWN_POWERS = (context, builder) -> {
        Collection<Object> entities;
        ArrayList powers = Lists.newArrayList();
        try {
            context.getArgument("entities", class_2300.class);
            entities = class_2186.method_9317((CommandContext)context, (String)"entities");
        }
        catch (Exception e) {
            entities = Collections.singleton(((class_2168)context.getSource()).method_9207());
        }
        for (class_1297 class_12972 : entities) {
            if (!(class_12972 instanceof class_1309)) continue;
            class_1309 living = (class_1309)class_12972;
            PowerHandler manager = PowerManager.getPowerHandler(living).orElse(new PowerHandler(living));
            block3: for (IPowerHolder holder : manager.getPowerHolders().values()) {
                for (AbilityInstance entry : holder.getAbilities().values()) {
                    if (!entry.getConfiguration().isBuyable()) continue;
                    if (powers.contains(holder.getPower().getId())) continue block3;
                    powers.add(holder.getPower().getId());
                    continue block3;
                }
            }
        }
        return class_2172.method_9270((Iterable)powers, (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<class_2168> SUGGEST_ABILITIES = (context, builder) -> {
        ArrayList abilities = Lists.newArrayList();
        Power power = null;
        try {
            context.getArgument("power", class_2960.class);
            power = SuperpowerCommand.getSuperpower((CommandContext<class_2168>)context, "power");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (power != null) {
            for (AbilityConfiguration ability : power.getAbilities()) {
                if (!ability.isBuyable()) continue;
                abilities.add(ability.getId());
            }
        }
        return class_2172.method_9265((Iterable)abilities, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ability").requires(player -> player.method_9259(2))).then(class_2170.method_9247((String)"lock").then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_OWN_POWERS).then(class_2170.method_9244((String)"ability", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ABILITIES).executes(context -> AbilityCommand.lockAbility((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<class_2168>)context, "power"), StringArgumentType.getString((CommandContext)context, (String)"ability"), true)))).then(class_2170.method_9247((String)"all").executes(context -> AbilityCommand.lockAllAbilities((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<class_2168>)context, "power"), true))))))).then(class_2170.method_9247((String)"unlock").then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"power", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_OWN_POWERS).then(class_2170.method_9244((String)"ability", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ABILITIES).executes(context -> AbilityCommand.lockAbility((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<class_2168>)context, "power"), StringArgumentType.getString((CommandContext)context, (String)"ability"), false)))).then(class_2170.method_9247((String)"all").executes(context -> AbilityCommand.lockAllAbilities((class_2168)context.getSource(), class_2186.method_9317((CommandContext)context, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<class_2168>)context, "power"), false)))))));
    }

    public static int lockAbility(class_2168 source, Collection<? extends class_1297> entities, Power power, String abilityKey, boolean locking) {
        AbilityConfiguration configuration = power.getAbilities().stream().filter(c -> c.getId().equals(abilityKey)).findFirst().orElse(null);
        if (configuration == null || !configuration.isBuyable()) {
            source.method_9213((class_2561)class_2561.method_43469((String)"commands.ability.error.notUnlockable", (Object[])new Object[]{abilityKey, power.getId()}));
            return 0;
        }
        int i = 0;
        for (class_1297 class_12972 : entities) {
            if (class_12972 instanceof class_1309) {
                class_1309 living = (class_1309)class_12972;
                IPowerHolder holder = PowerManager.getPowerHandler(living).orElse(new PowerHandler(living)).getPowerHolder(power);
                if (holder != null) {
                    AbilityInstance ability = holder.getAbilities().get(abilityKey);
                    if (ability == null) continue;
                    ability.setUniqueProperty(BuyableCondition.BOUGHT, !locking);
                    ++i;
                    continue;
                }
                source.method_9213((class_2561)class_2561.method_43471((String)"commands.ability.error.doesntHavePower"));
                continue;
            }
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.superpower.error.noLivingEntity"));
        }
        int finalI = i;
        source.method_9226(() -> class_2561.method_43469((String)("commands.ability." + (locking ? "locking" : "unlocking") + ".success"), (Object[])new Object[]{abilityKey, power.getId(), finalI}), true);
        return i;
    }

    public static int lockAllAbilities(class_2168 source, Collection<? extends class_1297> entities, Power power, boolean locking) {
        int i = 0;
        for (class_1297 class_12972 : entities) {
            if (class_12972 instanceof class_1309) {
                class_1309 living = (class_1309)class_12972;
                IPowerHolder holder = PowerManager.getPowerHandler(living).orElse(new PowerHandler(living)).getPowerHolder(power);
                if (holder != null) {
                    for (AbilityInstance abilityInstance : holder.getAbilities().values()) {
                        if (!abilityInstance.getPropertyManager().isRegistered(BuyableCondition.BOUGHT)) continue;
                        abilityInstance.setUniqueProperty(BuyableCondition.BOUGHT, !locking);
                        ++i;
                    }
                    continue;
                }
                source.method_9213((class_2561)class_2561.method_43471((String)"commands.ability.error.doesntHavePower"));
                continue;
            }
            source.method_9213((class_2561)class_2561.method_43471((String)"commands.superpower.error.noLivingEntity"));
        }
        int finalI = i;
        source.method_9226(() -> class_2561.method_43469((String)("commands.ability." + (locking ? "locking" : "unlocking") + ".all.success"), (Object[])new Object[]{finalI, power.getId(), entities.size()}), true);
        return i;
    }
}

