/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.geckolib.playeranimator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_3518;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ParsedAnimationController<T extends GeoAnimatable> {
    private final String name;
    private final int transitionTickTime;
    private final RawAnimation rawAnimation;
    private final PresetType preset;
    private final Map<String, RawAnimation> triggers = new HashMap<String, RawAnimation>();

    public ParsedAnimationController(String name, int transitionTickTime, RawAnimation rawAnimation) {
        this.name = name;
        this.transitionTickTime = transitionTickTime;
        this.rawAnimation = rawAnimation;
        this.preset = null;
    }

    public ParsedAnimationController(PresetType preset) {
        this.name = null;
        this.transitionTickTime = 0;
        this.rawAnimation = null;
        this.preset = preset;
    }

    public ParsedAnimationController<T> triggerableAnim(String key, RawAnimation animation) {
        this.triggers.put(key, animation);
        return this;
    }

    public AnimationController<T> createController(T animatable) {
        AnimationController controller = this.preset != null ? this.preset.createController(animatable) : new AnimationController(animatable, this.name, this.transitionTickTime, animationState -> animationState.setAndContinue(this.rawAnimation));
        for (Map.Entry<String, RawAnimation> e : this.triggers.entrySet()) {
            controller.triggerableAnim(e.getKey(), e.getValue()).receiveTriggeredAnimations();
        }
        return controller;
    }

    @NotNull
    public static <T extends GeoAnimatable> ParsedAnimationController<T> controllerFromJson(JsonObject json) {
        ParsedAnimationController<T> controller;
        if (class_3518.method_15294((JsonObject)json, (String)"preset")) {
            name = class_3518.method_15265((JsonObject)json, (String)"preset");
            PresetType presetType = PresetType.fromName(name);
            if (presetType == null) {
                throw new JsonParseException("Unknown animation controller preset '" + name + "'");
            }
            controller = new ParsedAnimationController<T>(presetType);
        } else {
            name = class_3518.method_15265((JsonObject)json, (String)"name");
            int transitionTicks = GsonUtil.getAsIntMin(json, "transition_tick_time", 0);
            RawAnimation rawAnimation = ParsedAnimationController.animationFromJson(json.get("animation"));
            controller = new ParsedAnimationController<T>(name, transitionTicks, rawAnimation);
        }
        if (class_3518.method_15294((JsonObject)json, (String)"triggers")) {
            JsonObject triggers = class_3518.method_15296((JsonObject)json, (String)"triggers");
            for (Map.Entry e : triggers.entrySet()) {
                controller.triggerableAnim((String)e.getKey(), ParsedAnimationController.animationFromJson((JsonElement)e.getValue()));
            }
        }
        return controller;
    }

    public static RawAnimation animationFromJson(JsonElement element) {
        RawAnimation animation = RawAnimation.begin();
        if (element == null || element.isJsonNull()) {
            return animation;
        }
        if (element.isJsonPrimitive()) {
            animation.thenPlay(element.getAsString());
        } else {
            JsonArray jsonArray = class_3518.method_15252((JsonElement)element, (String)"animation");
            for (JsonElement el : jsonArray) {
                JsonObject step = class_3518.method_15295((JsonElement)el, (String)"animation[].$");
                String type = class_3518.method_15265((JsonObject)step, (String)"type");
                if (type.equalsIgnoreCase("then_play")) {
                    animation.thenPlay(class_3518.method_15265((JsonObject)step, (String)"animation"));
                    continue;
                }
                if (type.equalsIgnoreCase("then_loop")) {
                    animation.thenLoop(class_3518.method_15265((JsonObject)step, (String)"animation"));
                    continue;
                }
                if (type.equalsIgnoreCase("then_wait")) {
                    animation.thenWait(class_3518.method_15260((JsonObject)step, (String)"ticks"));
                    continue;
                }
                if (type.equalsIgnoreCase("then_play_and_hold")) {
                    animation.thenPlayAndHold(class_3518.method_15265((JsonObject)step, (String)"animation"));
                    continue;
                }
                if (!type.equalsIgnoreCase("then_play_x_times")) continue;
                animation.thenPlayXTimes(class_3518.method_15265((JsonObject)step, (String)"animation"), class_3518.method_15260((JsonObject)step, (String)"play_count"));
            }
        }
        return animation;
    }

    public static enum PresetType {
        LIVING("living"),
        IDLE("idle"),
        SNEAK("sneak"),
        CRAWL("crawl"),
        WALK("walk"),
        WALK_OR_ELSE_IDLE("walk_or_else_idle"),
        ATTACK("attack"),
        SWIM("swim"),
        SWIM_OR_ELSE_IDLE("swim_or_else_idle"),
        FLY("fly"),
        FLY_OR_ELSE_IDLE("fly_or_else_idle"),
        WALK_RUN_OR_ELSE_IDLE("walk_run_or_else_idle");

        private final String name;

        private PresetType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public <T extends GeoAnimatable> AnimationController<T> createController(T animatable) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case LIVING -> DefaultAnimations.genericLivingController(animatable);
                case IDLE -> DefaultAnimations.genericIdleController(animatable);
                case SNEAK -> new AnimationController(animatable, "Sneak", 10, state -> state.setAndContinue(DefaultAnimations.SNEAK));
                case CRAWL -> new AnimationController(animatable, "Crawl", 10, state -> state.setAndContinue(DefaultAnimations.CRAWL));
                case WALK -> DefaultAnimations.genericWalkController(animatable);
                case WALK_OR_ELSE_IDLE -> DefaultAnimations.genericWalkIdleController(animatable);
                case ATTACK -> new AnimationController(animatable, "Attack", 5, state -> {
                    Object patt6684$temp = state.getData(DataTickets.ENTITY);
                    if (patt6684$temp instanceof class_1309) {
                        class_1309 living = (class_1309)patt6684$temp;
                        if (living.field_6252) {
                            return state.setAndContinue(DefaultAnimations.ATTACK_SWING);
                        }
                    }
                    state.getController().forceAnimationReset();
                    return PlayState.STOP;
                });
                case SWIM -> DefaultAnimations.genericSwimController(animatable);
                case SWIM_OR_ELSE_IDLE -> DefaultAnimations.genericSwimIdleController(animatable);
                case FLY -> DefaultAnimations.genericFlyController(animatable);
                case FLY_OR_ELSE_IDLE -> DefaultAnimations.genericFlyIdleController(animatable);
                case WALK_RUN_OR_ELSE_IDLE -> new AnimationController(animatable, "Walk/Run/Idle", 0, state -> {
                    if (state.isMoving()) {
                        class_1309 en;
                        Object patt7554$temp = state.getData(DataTickets.ENTITY);
                        return state.setAndContinue(patt7554$temp instanceof class_1309 && (en = (class_1309)patt7554$temp).method_5624() ? DefaultAnimations.RUN : DefaultAnimations.WALK);
                    }
                    return state.setAndContinue(DefaultAnimations.IDLE);
                });
            };
        }

        @Nullable
        public static PresetType fromName(String name) {
            for (PresetType presetType : PresetType.values()) {
                if (!presetType.getName().equalsIgnoreCase(name)) continue;
                return presetType;
            }
            return null;
        }
    }
}

