/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.class_1309;
import net.threetag.palladium.condition.ChatActionCondition;
import net.threetag.palladium.condition.ChatMessageCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class ChatActivationCondition
extends ChatMessageCondition {
    public final int ticks;

    public ChatActivationCondition(String chatMessage, int ticks, int cooldown) {
        super(chatMessage, cooldown);
        this.ticks = ticks;
    }

    @Override
    public boolean active(DataContext context) {
        class_1309 entity = context.getLivingEntity();
        AbilityInstance entry = context.getAbility();
        if (entity == null || entry == null) {
            return false;
        }
        if (this.cooldown != 0 && Objects.requireNonNull(entry).activationTimer == 1) {
            entry.startCooldown(context.getLivingEntity(), this.cooldown);
        }
        return Objects.requireNonNull(entry).activationTimer > 0;
    }

    @Override
    public void onChat(class_1309 entity, AbilityInstance entry) {
        if (entry.cooldown <= 0 && entry.activationTimer == 0) {
            entry.startActivationTimer(entity, this.ticks);
        }
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.CHAT_ACTIVATION.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<Integer> TICKS = new IntegerProperty("ticks").configurable("The amount of ticks the ability will be active for");

        public Serializer() {
            this.withProperty(ChatMessageCondition.CHAT_MESSAGE, "Hello World");
            this.withProperty(ChatActionCondition.Serializer.COOLDOWN, 0);
            this.withProperty(TICKS, 60);
        }

        @Override
        public Condition make(JsonObject json) {
            return new ChatActivationCondition(this.getProperty(json, ChatMessageCondition.CHAT_MESSAGE), this.getProperty(json, TICKS), this.getProperty(json, ChatActionCondition.Serializer.COOLDOWN));
        }

        @Override
        public ConditionEnvironment getContextEnvironment() {
            return ConditionEnvironment.DATA;
        }

        @Override
        public String getDocumentationDescription() {
            return "This condition is used to activate the ability when a chat message was sent for a certain amount of ticks.";
        }
    }
}

