/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.threetag.palladium.condition.ChatMessageCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.condition.CooldownType;
import net.threetag.palladium.condition.HeldCondition;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.context.DataContextType;
import net.threetag.palladium.util.property.PropertyManager;

public class ChatToggleCondition
extends ChatMessageCondition {
    public ChatToggleCondition(String chatMessage, int cooldown) {
        super(chatMessage, cooldown);
    }

    @Override
    public void init(class_1309 entity, AbilityInstance entry, PropertyManager manager) {
        entry.startCooldown(entity, this.cooldown);
    }

    @Override
    public boolean active(DataContext context) {
        class_1297 entity = context.get(DataContextType.ENTITY);
        AbilityInstance entry = context.get(DataContextType.ABILITY);
        if (entity == null || entry == null) {
            return false;
        }
        if (this.cooldown != 0 && entry.cooldown == 0) {
            entry.keyPressed = false;
        }
        return entry.keyPressed;
    }

    @Override
    public void onChat(class_1309 entity, AbilityInstance entry) {
        entry.keyPressed = !entry.keyPressed;
    }

    @Override
    public CooldownType getCooldownType() {
        return CooldownType.DYNAMIC;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.CHAT_TOGGLE.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public Serializer() {
            this.withProperty(ChatMessageCondition.CHAT_MESSAGE, "Hello World");
            this.withProperty(HeldCondition.Serializer.COOLDOWN, 0);
        }

        @Override
        public Condition make(JsonObject json) {
            return new ChatToggleCondition(this.getProperty(json, ChatMessageCondition.CHAT_MESSAGE), this.getProperty(json, HeldCondition.Serializer.COOLDOWN));
        }

        @Override
        public ConditionEnvironment getContextEnvironment() {
            return ConditionEnvironment.DATA;
        }

        @Override
        public String getDocumentationDescription() {
            return "Toggles the ability on and off after a chat message was sent.";
        }
    }
}

