/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.item.Openable;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PlayerSlotProperty;

public class OpenableItemProgressCondition
extends Condition {
    private final PlayerSlot slot;
    private final int min;
    private final int max;

    public OpenableItemProgressCondition(PlayerSlot slot, int min, int max) {
        this.slot = slot;
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean active(DataContext context) {
        class_1309 entity = context.getLivingEntity();
        if (entity == null) {
            return false;
        }
        List<class_1799> stacks = this.slot.getItems(entity);
        for (class_1799 stack : stacks) {
            int openProgress;
            Openable openable;
            class_1792 class_17922;
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof Openable) || !(openable = (Openable)class_17922).isOpen(stack) || (openProgress = openable.getOpeningProgress(stack)) < this.min || openProgress > this.max) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.OPENABLE_ITEM_PROGRESS.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<PlayerSlot> SLOT = new PlayerSlotProperty("slot").configurable("Slot that must contain an opened item");
        public static final PalladiumProperty<Integer> MIN = new IntegerProperty("min").configurable("Minimum required amount of the progress value");
        public static final PalladiumProperty<Integer> MAX = new IntegerProperty("max").configurable("Maximum required amount of the progress value");

        public Serializer() {
            this.withProperty(SLOT, PlayerSlot.get(class_1304.field_6174.method_5923()));
            this.withProperty(MIN, 0);
            this.withProperty(MAX, 0);
        }

        @Override
        public Condition make(JsonObject json) {
            return new OpenableItemProgressCondition(this.getProperty(json, SLOT), this.getProperty(json, MIN), this.getProperty(json, MAX));
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the openable item in the given slot has a certain amount of progress. Needs to be using the openable-system for items.";
        }
    }
}

