/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity;

import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_897;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.client.model.animation.PalladiumAnimationRegistry;
import net.threetag.palladium.client.renderer.item.armor.ArmorRendererData;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.compat.mermod.MermodClientCompat;
import net.threetag.palladium.entity.PlayerModelCacheExtension;
import net.threetag.palladium.item.ArmorWithRenderer;
import net.threetag.palladium.mixin.client.PlayerRendererInvoker;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.HideBodyPartAbility;
import net.threetag.palladium.power.ability.RemoveBodyPartAbility;
import net.threetag.palladium.util.SizeUtil;
import net.threetag.palladium.util.context.DataContext;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public enum BodyPart {
    HEAD("head", false),
    HEAD_OVERLAY("head_overlay", true),
    CHEST("chest", false),
    CHEST_OVERLAY("chest_overlay", true),
    RIGHT_ARM("right_arm", false),
    RIGHT_ARM_OVERLAY("right_arm_overlay", true),
    LEFT_ARM("left_arm", false),
    LEFT_ARM_OVERLAY("left_arm_overlay", true),
    RIGHT_LEG("right_leg", false),
    RIGHT_LEG_OVERLAY("right_leg_overlay", true),
    LEFT_LEG("left_leg", false),
    LEFT_LEG_OVERLAY("left_leg_overlay", true),
    CAPE("cape", false);

    private final String name;
    private final boolean overlay;
    public static final List<class_1792> HIDES_LAYER;

    private BodyPart(String name, boolean overlay) {
        this.name = name;
        this.overlay = overlay;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public class_630 getModelPart(class_572<?> model) {
        class_591 pl;
        class_591 playerModel = model instanceof class_591 ? (pl = (class_591)model) : null;
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case HEAD -> model.field_3398;
            case HEAD_OVERLAY -> model.field_3394;
            case CHEST -> model.field_3391;
            case CHEST_OVERLAY -> {
                if (playerModel != null) {
                    yield playerModel.field_3483;
                }
                yield null;
            }
            case RIGHT_ARM -> model.field_3401;
            case RIGHT_ARM_OVERLAY -> {
                if (playerModel != null) {
                    yield playerModel.field_3486;
                }
                yield null;
            }
            case LEFT_ARM -> model.field_27433;
            case LEFT_ARM_OVERLAY -> {
                if (playerModel != null) {
                    yield playerModel.field_3484;
                }
                yield null;
            }
            case RIGHT_LEG -> model.field_3392;
            case RIGHT_LEG_OVERLAY -> {
                if (playerModel != null) {
                    yield playerModel.field_3479;
                }
                yield null;
            }
            case LEFT_LEG -> model.field_3397;
            case LEFT_LEG_OVERLAY -> {
                if (playerModel != null) {
                    yield playerModel.field_3482;
                }
                yield null;
            }
            case CAPE -> playerModel != null ? playerModel.field_3485 : null;
        };
    }

    @Environment(value=EnvType.CLIENT)
    public void setVisibility(class_572<?> model, boolean visible) {
        class_630 part = this.getModelPart(model);
        if (part != null) {
            part.field_3665 = visible;
        }
    }

    public static BodyPart fromJson(String name) {
        BodyPart part = BodyPart.byName(name);
        if (part != null) {
            return part;
        }
        throw new JsonParseException("Unknown body part '" + name + "'");
    }

    public static BodyPart byName(String name) {
        for (BodyPart bodyPart : BodyPart.values()) {
            if (!name.equalsIgnoreCase(bodyPart.name)) continue;
            return bodyPart;
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public static void hideHiddenOrRemovedParts(class_572<?> model, class_1309 entity, ModifiedBodyPartResult result) {
        for (BodyPart part : BodyPart.values()) {
            if (!result.isHiddenOrRemoved(part)) continue;
            part.setVisibility(model, false);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void hideRemovedParts(class_572<?> model, class_1309 entity, ModifiedBodyPartResult result) {
        for (BodyPart part : BodyPart.values()) {
            if (!result.isRemoved(part)) continue;
            part.setVisibility(model, false);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void resetBodyParts(class_1309 entity, class_572<?> model) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_7325()) {
                model.method_2805(false);
                model.field_3398.field_3665 = true;
                model.field_3394.field_3665 = true;
            } else {
                model.method_2805(true);
                model.field_3394.field_3665 = player.method_7348(class_1664.field_7563);
                if (model instanceof class_591) {
                    class_591 playerModel = (class_591)model;
                    playerModel.field_3483.field_3665 = player.method_7348(class_1664.field_7564);
                    playerModel.field_3482.field_3665 = player.method_7348(class_1664.field_7566);
                    playerModel.field_3479.field_3665 = player.method_7348(class_1664.field_7565);
                    playerModel.field_3484.field_3665 = player.method_7348(class_1664.field_7568);
                    playerModel.field_3486.field_3665 = player.method_7348(class_1664.field_7570);
                    playerModel.field_3485.field_3665 = player.method_7348(class_1664.field_7559);
                    if (MermodClientCompat.INSTANCE.shouldRenderTail(player)) {
                        playerModel.field_3392.field_3665 = false;
                        playerModel.field_3479.field_3665 = false;
                        playerModel.field_3397.field_3665 = false;
                        playerModel.field_3482.field_3665 = false;
                    }
                }
            }
        } else {
            model.method_2805(true);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static ModifiedBodyPartResult getModifiedBodyParts(class_1309 entity, boolean isFirstPerson) {
        return BodyPart.getModifiedBodyParts(entity, isFirstPerson, true);
    }

    @Environment(value=EnvType.CLIENT)
    public static ModifiedBodyPartResult getModifiedBodyParts(class_1309 entity, boolean isFirstPerson, boolean includeAccessories) {
        ModifiedBodyPartResult result = new ModifiedBodyPartResult();
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            for (class_1304 slot : class_1304.values()) {
                ArmorRendererData renderer;
                ArmorWithRenderer armorWithRenderer;
                Object object;
                class_1799 stack;
                if (slot.method_5925() != class_1304.class_1305.field_6178 || !HIDES_LAYER.contains((stack = player.method_6118(slot)).method_7909()) && (!((object = stack.method_7909()) instanceof ArmorWithRenderer) || !((object = (armorWithRenderer = (ArmorWithRenderer)object).getCachedArmorRenderer()) instanceof ArmorRendererData) || !(renderer = (ArmorRendererData)object).hidesSecondPlayerLayer(DataContext.forArmorInSlot((class_1309)player, slot)))) continue;
                if (slot == class_1304.field_6169) {
                    result.remove(HEAD_OVERLAY);
                    continue;
                }
                if (slot == class_1304.field_6174) {
                    result.remove(CHEST_OVERLAY);
                    result.remove(RIGHT_ARM_OVERLAY);
                    result.remove(LEFT_ARM_OVERLAY);
                    continue;
                }
                result.remove(RIGHT_LEG_OVERLAY);
                result.remove(LEFT_LEG_OVERLAY);
            }
            if (includeAccessories) {
                Accessory.getPlayerData(player).ifPresent(data -> data.getSlots().forEach((slot, accessories) -> {
                    if (!accessories.isEmpty()) {
                        for (BodyPart part : slot.getHiddenBodyParts(player)) {
                            result.hide(part);
                        }
                    }
                }));
            }
        }
        for (AbilityInstance bodyPartHide : AbilityUtil.getEnabledEntries(entity, (Ability)Abilities.HIDE_BODY_PART.get())) {
            if (isFirstPerson && !bodyPartHide.getProperty(HideBodyPartAbility.AFFECTS_FIRST_PERSON).booleanValue()) continue;
            for (BodyPart part : bodyPartHide.getProperty(HideBodyPartAbility.BODY_PARTS)) {
                result.hide(part);
            }
        }
        for (AbilityInstance bodyPartHide : AbilityUtil.getEnabledEntries(entity, (Ability)Abilities.REMOVE_BODY_PART.get())) {
            if (isFirstPerson && !bodyPartHide.getProperty(RemoveBodyPartAbility.AFFECTS_FIRST_PERSON).booleanValue()) continue;
            for (BodyPart part : bodyPartHide.getProperty(RemoveBodyPartAbility.BODY_PARTS)) {
                result.remove(part);
            }
        }
        PackRenderLayerManager.forEachLayer((class_1297)entity, (context, layer) -> {
            for (BodyPart part : layer.getHiddenBodyParts(entity)) {
                result.hide(part);
            }
        });
        return result;
    }

    @Environment(value=EnvType.CLIENT)
    public static Matrix4f getTransformationMatrix(BodyPart part, Vector3f offset, class_572<?> model, class_742 player, float partialTicks) {
        class_4587 poseStack = new class_4587();
        class_630 modelPart = part.getModelPart(model);
        if (modelPart == null) {
            return poseStack.method_23760().method_23761();
        }
        class_897 renderer = class_310.method_1551().method_1561().method_3953((class_1297)player);
        if (renderer instanceof PlayerRendererInvoker) {
            class_1297 class_12972;
            PlayerRendererInvoker invoker = (PlayerRendererInvoker)renderer;
            float width = SizeUtil.getInstance().getModelWidthScale((class_1297)player, partialTicks);
            float height = SizeUtil.getInstance().getModelHeightScale((class_1297)player, partialTicks);
            poseStack.method_22905(width, height, width);
            float f = class_3532.method_17821((float)partialTicks, (float)player.field_6220, (float)player.field_6283);
            float g = class_3532.method_17821((float)partialTicks, (float)player.field_6259, (float)player.field_6241);
            if (player.method_5765() && (class_12972 = player.method_5854()) instanceof class_1309) {
                class_1309 livingEntity = (class_1309)class_12972;
                f = class_3532.method_17821((float)partialTicks, (float)livingEntity.field_6220, (float)livingEntity.field_6283);
                float h = g - f;
                float i = class_3532.method_15393((float)h);
                if (i < -85.0f) {
                    i = -85.0f;
                }
                if (i >= 85.0f) {
                    i = 85.0f;
                }
                f = g - i;
                if (i * i > 2500.0f) {
                    f += i * 0.2f;
                }
            }
            invoker.invokeSetupRotations(player, poseStack, (float)player.field_6012 + partialTicks, f, partialTicks);
            PalladiumAnimationRegistry.setupRotations((class_1007)renderer, player, poseStack, partialTicks);
            poseStack.method_22905(-1.0f, -1.0f, 1.0f);
            invoker.invokeScale(player, poseStack, partialTicks);
            poseStack.method_46416(0.0f, -1.501f, 0.0f);
            modelPart.method_22703(poseStack);
            poseStack.method_46416(offset.x, offset.y, offset.z);
        }
        return poseStack.method_23760().method_23761();
    }

    @Environment(value=EnvType.CLIENT)
    public static Matrix4f getTransformationMatrix(BodyPart part, Vector3f offset, class_742 player, float partialTicks) {
        if (player instanceof PlayerModelCacheExtension) {
            PlayerModelCacheExtension ext = (PlayerModelCacheExtension)player;
            return BodyPart.getTransformationMatrix(part, offset, ext.palladium$getCachedModel(), player, partialTicks);
        }
        return new Matrix4f();
    }

    @Environment(value=EnvType.CLIENT)
    public static class_243 getInWorldPosition(BodyPart part, Vector3f offset, class_572<?> model, class_742 player, float partialTicks) {
        Vector3f vec = new Vector3f(0.0f, 0.0f, 0.0f);
        vec = BodyPart.getTransformationMatrix(part, offset, model, player, partialTicks).transformPosition(vec);
        return player.method_30950(partialTicks).method_1031((double)vec.x, (double)vec.y, (double)vec.z);
    }

    @Environment(value=EnvType.CLIENT)
    public static class_243 getInWorldPosition(BodyPart part, Vector3f offset, class_742 player, float partialTicks) {
        if (player instanceof PlayerModelCacheExtension) {
            PlayerModelCacheExtension ext = (PlayerModelCacheExtension)player;
            return BodyPart.getInWorldPosition(part, offset, ext.palladium$getCachedModel(), player, partialTicks);
        }
        return player.method_30950(partialTicks);
    }

    static {
        HIDES_LAYER = new ArrayList<class_1792>();
    }

    public static class ModifiedBodyPartResult {
        private final Map<BodyPart, Integer> states = new HashMap<BodyPart, Integer>();

        public ModifiedBodyPartResult hide(BodyPart part) {
            return this.set(part, false);
        }

        public ModifiedBodyPartResult remove(BodyPart part) {
            return this.set(part, true);
        }

        public ModifiedBodyPartResult set(BodyPart part, boolean remove) {
            int mod;
            int n = mod = remove ? 2 : 1;
            if (!this.states.containsKey((Object)part)) {
                this.states.put(part, mod);
            } else {
                this.states.put(part, Math.max(this.states.get((Object)part), mod));
            }
            return this;
        }

        public boolean isHiddenOrRemoved(BodyPart bodyPart) {
            return this.states.containsKey((Object)bodyPart);
        }

        public boolean isHidden(BodyPart bodyPart) {
            return this.states.containsKey((Object)bodyPart) && this.states.get((Object)bodyPart) == 1;
        }

        public boolean isRemoved(BodyPart bodyPart) {
            return this.states.containsKey((Object)bodyPart) && this.states.get((Object)bodyPart) == 2;
        }
    }
}

