/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonAttributeContainer;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class AddonBlockItem
extends class_1747
implements IAddonItem {
    private List<class_2561> tooltipLines;
    private IAddonItem.RenderLayerContainer renderLayerContainer = null;
    private final AddonAttributeContainer attributeContainer = new AddonAttributeContainer();
    private boolean shouldRenderModel = true;

    public AddonBlockItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
        if (this.tooltipLines != null) {
            tooltipComponents.addAll(this.tooltipLines);
        }
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return this.attributeContainer.get(PlayerSlot.get(slot), (Multimap<class_1320, class_1322>)super.method_7844(slot));
    }

    @Override
    public AddonAttributeContainer getAttributeContainer() {
        return this.attributeContainer;
    }

    @Override
    public void setTooltip(List<class_2561> lines) {
        this.tooltipLines = lines;
    }

    @Override
    public void setRenderLayerContainer(IAddonItem.RenderLayerContainer container) {
        this.renderLayerContainer = container;
    }

    @Override
    public IAddonItem.RenderLayerContainer getRenderLayerContainer() {
        return this.renderLayerContainer;
    }

    @Override
    public void setShouldRenderModel(boolean shouldRender) {
        this.shouldRenderModel = shouldRender;
    }

    @Override
    public boolean shouldRenderModel() {
        return this.shouldRenderModel;
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, class_1792.class_1793 properties) {
            class_2960 blockId = GsonUtil.getAsResourceLocation(json, "block");
            if (!class_7923.field_41175.method_10250(blockId)) {
                throw new JsonParseException("Unknown block '" + String.valueOf(blockId) + "'");
            }
            return new AddonBlockItem((class_2248)class_7923.field_41175.method_10223(blockId), properties);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Block Item");
            builder.setDescription("Item for a block, duh");
            builder.addProperty("block", class_2960.class).description("ID of the block that this item is for").required().exampleJson((JsonElement)new JsonPrimitive("test:test_block"));
        }

        @Override
        public class_2960 getId() {
            return new class_2960("palladium", "block_item");
        }
    }
}

