/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1744;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonAttributeContainer;
import net.threetag.palladium.item.AddonProjectileItem;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class AddonBowItem
extends class_1753
implements IAddonItem {
    private List<class_2561> tooltipLines;
    private IAddonItem.RenderLayerContainer renderLayerContainer = null;
    private final AddonAttributeContainer attributeContainer = new AddonAttributeContainer();
    private boolean shouldRenderModel = true;
    private final float velocity;
    private final float inaccuracy;
    private final int useDuration;
    private final Predicate<class_1799> projectiles;
    @Nullable
    private final Predicate<class_1799> heldProjectiles;

    public AddonBowItem(float velocity, float inaccuracy, int useDuration, Predicate<class_1799> projectiles, @Nullable Predicate<class_1799> heldProjectiles, class_1792.class_1793 properties) {
        super(properties);
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        this.useDuration = useDuration;
        this.projectiles = projectiles;
        this.heldProjectiles = heldProjectiles;
    }

    public int method_7881(class_1799 stack) {
        return this.useDuration;
    }

    public Predicate<class_1799> method_19268() {
        return this.projectiles;
    }

    public Predicate<class_1799> method_20310() {
        return this.heldProjectiles == null ? this.method_19268() : this.heldProjectiles;
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 livingEntity, int timeCharged) {
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            boolean bl = player.method_31549().field_7477 || class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)stack) > 0;
            class_1799 itemStack = player.method_18808(stack);
            if (!itemStack.method_7960() || bl) {
                int i;
                float f;
                if (itemStack.method_7960()) {
                    itemStack = new class_1799((class_1935)class_1802.field_8107);
                }
                if (!((double)(f = AddonBowItem.method_7722((int)(i = this.method_7881(stack) - timeCharged))) < 0.1)) {
                    boolean bl2;
                    boolean bl3 = bl2 = bl && itemStack.method_31574(class_1802.field_8107);
                    if (!level.field_9236) {
                        class_1792 item = itemStack.method_7909();
                        if (item instanceof AddonProjectileItem) {
                            AddonProjectileItem projectileItem = (AddonProjectileItem)item;
                            class_1676 entity = projectileItem.createProjectile(level, itemStack, livingEntity);
                            if (entity != null) {
                                entity.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, f * this.velocity, this.inaccuracy);
                                if (class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)stack) > 0) {
                                    entity.method_5639(100);
                                }
                                level.method_8649((class_1297)entity);
                            }
                        } else {
                            int k;
                            int j;
                            class_1744 arrowItem = (class_1744)(itemStack.method_7909() instanceof class_1744 ? itemStack.method_7909() : class_1802.field_8107);
                            class_1665 abstractArrow = arrowItem.method_7702(level, itemStack, (class_1309)player);
                            abstractArrow.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, f * this.velocity, this.inaccuracy);
                            if (f == 1.0f) {
                                abstractArrow.method_7439(true);
                            }
                            if ((j = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)stack)) > 0) {
                                abstractArrow.method_7438(abstractArrow.method_7448() + (double)j * 0.5 + 0.5);
                            }
                            if ((k = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)stack)) > 0) {
                                abstractArrow.method_7449(k);
                            }
                            if (class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)stack) > 0) {
                                abstractArrow.method_5639(100);
                            }
                            stack.method_7956(1, (class_1309)player, player2 -> player2.method_20236(player.method_6058()));
                            if (bl2 || player.method_31549().field_7477 && (itemStack.method_31574(class_1802.field_8236) || itemStack.method_31574(class_1802.field_8087))) {
                                abstractArrow.field_7572 = class_1665.class_1666.field_7594;
                            }
                            level.method_8649((class_1297)abstractArrow);
                        }
                    }
                    level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, 1.0f / (level.method_8409().method_43057() * 0.4f + 1.2f) + f * 0.5f);
                    if (!bl2 && !player.method_31549().field_7477) {
                        itemStack.method_7934(1);
                        if (itemStack.method_7960()) {
                            player.method_31548().method_7378(itemStack);
                        }
                    }
                    player.method_7259(class_3468.field_15372.method_14956((Object)this));
                }
            }
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
        if (this.tooltipLines != null) {
            tooltipComponents.addAll(this.tooltipLines);
        }
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return this.attributeContainer.get(PlayerSlot.get(slot), (Multimap<class_1320, class_1322>)super.method_7844(slot));
    }

    @Override
    public AddonAttributeContainer getAttributeContainer() {
        return this.attributeContainer;
    }

    @Override
    public void setTooltip(List<class_2561> lines) {
        this.tooltipLines = lines;
    }

    @Override
    public void setRenderLayerContainer(IAddonItem.RenderLayerContainer container) {
        this.renderLayerContainer = container;
    }

    @Override
    public IAddonItem.RenderLayerContainer getRenderLayerContainer() {
        return this.renderLayerContainer;
    }

    @Override
    public void setShouldRenderModel(boolean shouldRender) {
        this.shouldRenderModel = shouldRender;
    }

    @Override
    public boolean shouldRenderModel() {
        return this.shouldRenderModel;
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, class_1792.class_1793 properties) {
            float velocity = class_3518.method_15277((JsonObject)json, (String)"velocity", (float)3.0f);
            float inaccuracy = class_3518.method_15277((JsonObject)json, (String)"inaccuracy", (float)1.0f);
            int useDuration = class_3518.method_15282((JsonObject)json, (String)"use_duration", (int)72000);
            class_6862 projectiles = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)GsonUtil.getAsResourceLocation(json, "projectiles", new class_2960("minecraft:arrows")));
            class_6862 heldProjectiles = json.has("held_projectiles") ? class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)GsonUtil.getAsResourceLocation(json, "held_projectiles")) : null;
            return new AddonBowItem(velocity, inaccuracy, useDuration, stack -> stack.method_31573(projectiles), heldProjectiles == null ? null : stack -> stack.method_31573(heldProjectiles), properties);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Bow");
            builder.addProperty("velocity", Float.class).description("Velocity multiplier for the shot projectile").fallback(Float.valueOf(3.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(3.0f)));
            builder.addProperty("inaccuracy", Float.class).description("Inaccuracy for the shot projectile").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("use_duration", Integer.class).description("Amount of ticks the bow can be used for").fallback(72000).exampleJson((JsonElement)new JsonPrimitive((Number)72000));
            builder.addProperty("projectiles", class_2960.class).description("Item tag which contains all items that can be shot. By default all Minecraft arrows").fallback(new class_2960("arrows")).exampleJson((JsonElement)new JsonPrimitive("minecraft:arrows"));
            builder.addProperty("held_projectiles", class_2960.class).description("Item tag which contains all items that can be shot by being in the off hand. Can be left out to fallback to the 'projectiles' option").fallback(null).exampleJson((JsonElement)new JsonPrimitive("minecraft:arrows"));
        }

        @Override
        public class_2960 getId() {
            return Palladium.id("bow");
        }
    }
}

