/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.mixin;

import com.mojang.authlib.GameProfile;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_4050;
import net.threetag.palladium.accessory.AccessoryPlayerData;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.ToolHandsAbility;
import net.threetag.palladiumcore.util.PlayerUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
implements PalladiumPlayerExtension {
    @Unique
    private FlightHandler palladium$flightHandler;
    @Unique
    private AccessoryPlayerData palladium$accessories;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void init(class_1937 level, class_2338 blockPos, float yRot, GameProfile gameProfile, CallbackInfo ci) {
        this.palladium$getFlightHandler();
        this.palladium$accessories = new AccessoryPlayerData();
        PlayerUtil.refreshDisplayName((class_1657)((class_1657)this));
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        this.palladium$flightHandler.tick();
    }

    @ModifyVariable(method={"getDimensions"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private class_4050 getDimensions(class_4050 pose) {
        float hover = this.palladium$flightHandler.getHoveringAnimation(0.0f);
        float levitation = this.palladium$flightHandler.getLevitationAnimation(0.0f);
        float flight = this.palladium$flightHandler.getFlightAnimation(0.0f);
        if (hover > 0.0f || levitation > 0.0f || flight > 0.0f) {
            if (this.palladium$flightHandler.flightBoost > 1.0f) {
                return class_4050.field_18077;
            }
            return class_4050.field_18076;
        }
        return pose;
    }

    @ModifyVariable(method={"getStandingEyeHeight"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private class_4050 getStandingEyeHeight(class_4050 pose) {
        float hover = this.palladium$getFlightHandler().getHoveringAnimation(0.0f);
        float levitation = this.palladium$getFlightHandler().getLevitationAnimation(0.0f);
        float flight = this.palladium$getFlightHandler().getFlightAnimation(0.0f);
        if (hover > 0.0f || levitation > 0.0f || flight > 0.0f) {
            if (this.palladium$getFlightHandler().flightBoost > 1.0f) {
                return class_4050.field_18077;
            }
            return class_4050.field_18076;
        }
        return pose;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    public void readAdditionalSaveData(class_2487 compound, CallbackInfo ci) {
        class_2487 palladiumTag;
        class_2487 class_24872 = palladiumTag = compound.method_10545("Palladium") ? compound.method_10562("Palladium") : new class_2487();
        if (palladiumTag.method_10573("Accessories", 10)) {
            this.palladium$accessories.fromNBT(palladiumTag.method_10562("Accessories"));
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    public void addAdditionalSaveData(class_2487 compound, CallbackInfo ci) {
        class_2487 palladiumTag = compound.method_10545("Palladium") ? compound.method_10562("Palladium") : new class_2487();
        palladiumTag.method_10566("Accessories", (class_2520)this.palladium$accessories.toNBT());
        compound.method_10566("Palladium", (class_2520)palladiumTag);
    }

    @Inject(method={"hasCorrectToolForDrops"}, at={@At(value="RETURN")}, cancellable=true)
    public void palladium$hasCorrectToolForDrops(class_2680 state, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            AbilityUtil.getEnabledInstances((class_1309)this, (Ability)Abilities.TOOL_HANDS.get()).forEach(abilityInstance -> {
                if (ToolHandsAbility.blockDrops(abilityInstance, state)) {
                    cir.setReturnValue((Object)true);
                }
            });
        }
    }

    @Override
    public FlightHandler palladium$getFlightHandler() {
        if (this.palladium$flightHandler == null) {
            this.palladium$flightHandler = new FlightHandler((class_1657)this);
        }
        return this.palladium$flightHandler;
    }

    @Override
    public AccessoryPlayerData palladium$getAccessories() {
        return this.palladium$accessories;
    }
}

