/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.client.screen.AccessoryScreen;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;

public class SyncAccessoriesMessage
extends MessageS2C {
    public int entityId;
    public Map<AccessorySlot, Collection<Accessory>> accessories;

    public SyncAccessoriesMessage(int entityId, Map<AccessorySlot, Collection<Accessory>> accessories) {
        this.entityId = entityId;
        this.accessories = accessories;
    }

    public SyncAccessoriesMessage(class_2540 buf) {
        this.entityId = buf.readInt();
        int amount = buf.readInt();
        this.accessories = new HashMap<AccessorySlot, Collection<Accessory>>();
        for (int i = 0; i < amount; ++i) {
            AccessorySlot slot = AccessorySlot.getSlotByName(buf.method_10810());
            ArrayList<Accessory> accessories1 = new ArrayList<Accessory>();
            int slotAmount = buf.readInt();
            for (int j = 0; j < slotAmount; ++j) {
                Accessory accessory = (Accessory)Accessory.REGISTRY.get(buf.method_10810());
                if (accessory == null) continue;
                accessories1.add(accessory);
            }
            this.accessories.put(slot, accessories1);
        }
    }

    public MessageType getType() {
        return PalladiumNetwork.SYNC_ACCESSORIES;
    }

    public void toBytes(class_2540 buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.accessories.size());
        this.accessories.forEach((slot, accessories) -> {
            buf.method_10812(slot.getName());
            buf.writeInt(accessories.size());
            for (Accessory accessory : accessories) {
                buf.method_10812(Accessory.REGISTRY.getKey((Object)accessory));
            }
        });
    }

    public void handle(MessageContext context) {
        this.handleClient();
    }

    @Environment(value=EnvType.CLIENT)
    public void handleClient() {
        class_1297 entity = Objects.requireNonNull(class_310.method_1551().field_1687).method_8469(this.entityId);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Accessory.getPlayerData(player).ifPresent(data -> {
                data.clear(player);
                this.accessories.forEach((slot, accessories) -> {
                    for (Accessory accessory : accessories) {
                        data.enable((AccessorySlot)slot, accessory, player);
                    }
                });
                if (class_310.method_1551().field_1755 instanceof AccessoryScreen) {
                    ((AccessoryScreen)class_310.method_1551().field_1755).accessoryList.refreshList();
                }
            });
        }
    }
}

