/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladiumcore.registry.ReloadListenerRegistry;
import org.jetbrains.annotations.Nullable;

public class ItemPowerManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static ItemPowerManager INSTANCE;
    private final Map<String, Map<class_1792, List<Power>>> itemPowers = new HashMap<String, Map<class_1792, List<Power>>>();

    public static void init() {
        INSTANCE = new ItemPowerManager();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_2960)Palladium.id("item_powers"), (class_3302)INSTANCE);
    }

    public ItemPowerManager() {
        super(GSON, "palladium/item_powers");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        this.itemPowers.clear();
        object.forEach((id, json) -> {
            try {
                JsonObject jsonObject = class_3518.method_15295((JsonElement)json, (String)"$");
                String slot = class_3518.method_15265((JsonObject)jsonObject, (String)"slot");
                ArrayList<Object> powers = new ArrayList<Object>();
                if (jsonObject.get("power").isJsonPrimitive()) {
                    Power power = PowerManager.getInstance(null).getPower(new class_2960(jsonObject.get("power").getAsString()));
                    if (power == null) {
                        AddonPackLog.warning("Unknown power used for item '" + jsonObject.get("power").getAsString() + "'", new Object[0]);
                    } else {
                        powers.add(power);
                    }
                } else if (jsonObject.get("power").isJsonArray()) {
                    for (JsonElement jsonElement : class_3518.method_15261((JsonObject)jsonObject, (String)"power")) {
                        Power power = PowerManager.getInstance(null).getPower(new class_2960(jsonElement.getAsString()));
                        if (power == null) {
                            AddonPackLog.warning("Unknown power used for item '" + jsonElement.getAsString() + "'", new Object[0]);
                            continue;
                        }
                        powers.add(power);
                    }
                } else {
                    throw new JsonSyntaxException("Expected power to be string or array of strings");
                }
                List<Object> items = new ArrayList();
                if (jsonObject.get("item").isJsonPrimitive()) {
                    class_2960 itemId = new class_2960(jsonObject.get("item").getAsString());
                    if (!class_7923.field_41178.method_10250(itemId)) {
                        throw new JsonParseException("Unknown item '" + String.valueOf(itemId) + "'");
                    }
                    items = List.of((class_1792)class_7923.field_41178.method_10223(itemId));
                } else if (jsonObject.get("item").isJsonArray()) {
                    for (JsonElement jsonElement : class_3518.method_15261((JsonObject)jsonObject, (String)"item")) {
                        class_2960 itemId = new class_2960(jsonElement.getAsString());
                        if (!class_7923.field_41178.method_10250(itemId)) {
                            throw new JsonParseException("Unknown item '" + String.valueOf(itemId) + "'");
                        }
                        items.add((class_1792)class_7923.field_41178.method_10223(itemId));
                    }
                } else {
                    throw new JsonSyntaxException("Expected item to be string or array of strings");
                }
                for (class_1792 class_17922 : items) {
                    this.itemPowers.computeIfAbsent(slot, s -> new HashMap()).computeIfAbsent(class_17922, item1 -> new ArrayList()).addAll(powers);
                }
            }
            catch (Exception exception) {
                AddonPackLog.error("Parsing error loading item powers {}", id, exception);
            }
        });
        AddonPackLog.info("Loaded {} item powers", this.itemPowers.size());
    }

    @Nullable
    public List<Power> getPowerForItem(String slot, class_1792 item) {
        return this.itemPowers.containsKey(slot) ? this.itemPowers.get(slot).get(item) : null;
    }

    public static ItemPowerManager getInstance() {
        return INSTANCE;
    }
}

