/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.threetag.palladium.network.UpdatePowersMessage;
import net.threetag.palladium.power.DefaultPowerHolder;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.IPowerValidator;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerCollector;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.provider.PowerProvider;

public class PowerHandler
implements IPowerHandler {
    private final Map<class_2960, IPowerHolder> powers = new HashMap<class_2960, IPowerHolder>();
    private final class_1309 entity;
    private class_2487 powerData = new class_2487();

    public PowerHandler(class_1309 entity) {
        this.entity = entity;
    }

    @Override
    public Map<class_2960, IPowerHolder> getPowerHolders() {
        return ImmutableMap.copyOf(this.powers);
    }

    @Override
    public void tick() {
        if (!this.entity.method_37908().field_9236) {
            ArrayList<IPowerHolder> toRemove = new ArrayList<IPowerHolder>();
            PowerCollector collector = new PowerCollector(this.entity, this, toRemove);
            for (IPowerHolder iPowerHolder : this.powers.values()) {
                if (!iPowerHolder.isInvalid()) continue;
                toRemove.add(iPowerHolder);
            }
            for (PowerProvider powerProvider : PowerProvider.REGISTRY.getValues()) {
                powerProvider.providePowers(this.entity, this, collector);
            }
            for (IPowerHolder iPowerHolder : toRemove) {
                this.removePowerHolder(iPowerHolder.getPower());
            }
            for (DefaultPowerHolder defaultPowerHolder : collector.getAdded()) {
                this.setPowerHolder(defaultPowerHolder.getPower(), defaultPowerHolder);
            }
            if (!toRemove.isEmpty() || !collector.getAdded().isEmpty()) {
                UpdatePowersMessage msg = new UpdatePowersMessage(this.entity, toRemove.stream().map(p -> p.getPower().getId()).toList(), collector.getAdded().stream().map(p -> p.getPower().getId()).toList());
                class_1309 class_13092 = this.entity;
                if (class_13092 instanceof class_3222) {
                    class_3222 class_32222 = (class_3222)class_13092;
                    msg.sendToTrackingAndSelf(class_32222);
                } else {
                    msg.sendToTracking((class_1297)this.entity);
                }
            }
        }
        for (IPowerHolder holder : this.powers.values()) {
            holder.tick();
        }
    }

    public void setPowerHolder(Power power, IPowerHolder holder) {
        if (this.hasPower(power)) {
            this.powers.put(power.getId(), holder);
        } else {
            this.removePowerHolder(power);
            this.powers.put(power.getId(), holder);
            holder.fromNBT(this.powerData.method_10562(power.getId().toString()));
            holder.firstTick();
        }
    }

    public void removePowerHolder(Power power) {
        this.removePowerHolder(power.getId());
    }

    public void removePowerHolder(class_2960 powerId) {
        if (this.powers.containsKey(powerId)) {
            IPowerHolder holder = this.powers.get(powerId);
            boolean isStillValid = !holder.getPower().isInvalid();
            boolean hasPersistentData = holder.getPower().hasPersistentData();
            holder.lastTick();
            if (hasPersistentData) {
                this.savePowerNbt(holder);
            }
            this.powers.remove(powerId);
            if (isStillValid && !hasPersistentData) {
                this.powerData.method_10551(powerId.toString());
            }
        }
    }

    @Override
    public IPowerHolder getPowerHolder(Power power) {
        return this.powers.get(power.getId());
    }

    @Override
    public boolean hasPower(Power power) {
        return this.powers.containsKey(power.getId());
    }

    @Override
    public void removeAndAddPowers(List<Power> toRemove, List<Power> toAdd) {
        if (this.entity.method_37908().field_9236) {
            for (Power power : toRemove) {
                this.removePowerHolder(power);
            }
            for (Power power : toAdd) {
                this.setPowerHolder(power, new DefaultPowerHolder(this.entity, power, IPowerValidator.ALWAYS_ACTIVE));
            }
        }
    }

    @Override
    public void fromNBT(class_2487 nbt) {
        this.powerData = nbt;
    }

    @Override
    public class_2487 toNBT() {
        for (IPowerHolder holder : this.powers.values()) {
            this.savePowerNbt(holder);
        }
        this.cleanPowerData();
        return this.powerData;
    }

    public void savePowerNbt(IPowerHolder holder) {
        this.powerData.method_10566(holder.getPower().getId().toString(), (class_2520)holder.toNBT(true));
    }

    public void cleanPowerData() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : this.powerData.method_10541()) {
            if (PowerManager.getInstance(this.entity.method_37908()).getPower(new class_2960(key)) != null) continue;
            toRemove.add(key);
        }
        for (String key : toRemove) {
            this.powerData.method_10551(key);
        }
    }
}

