/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.ability.AbilityInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbilityReference {
    @Nullable
    private final class_2960 powerId;
    @NotNull
    private final String abilityId;

    public AbilityReference(@Nullable class_2960 powerId, @NotNull String abilityId) {
        this.powerId = powerId;
        this.abilityId = abilityId;
    }

    public static AbilityReference fromString(String parse) {
        String[] s = parse.split("#", 2);
        if (s.length == 1) {
            return new AbilityReference(null, s[0]);
        }
        return new AbilityReference(new class_2960(s[0]), s[1]);
    }

    @Nullable
    public class_2960 getPowerId() {
        return this.powerId;
    }

    @NotNull
    public String getAbilityId() {
        return this.abilityId;
    }

    @Nullable
    public AbilityInstance getEntry(class_1309 entity) {
        return this.getEntry(entity, null);
    }

    @Nullable
    public AbilityInstance getEntry(class_1309 entity, @Nullable IPowerHolder powerHolder) {
        if (this.powerId != null) {
            IPowerHandler handler = PowerManager.getPowerHandler(entity).orElse(null);
            Power power = PowerManager.getInstance(entity.method_37908()).getPower(this.powerId);
            powerHolder = power != null && handler != null ? handler.getPowerHolder(power) : null;
        }
        if (powerHolder != null) {
            return powerHolder.getAbilities().get(this.abilityId);
        }
        return null;
    }

    public Optional<AbilityInstance> optional(class_1309 entity, @Nullable IPowerHolder powerHolder) {
        return Optional.ofNullable(this.getEntry(entity, powerHolder));
    }

    public void toBuffer(class_2540 buf) {
        buf.method_43826((Object)this.powerId, (buf1, resourceLocation) -> buf.method_10812(resourceLocation));
        buf.method_10814(this.abilityId);
    }

    public static AbilityReference fromBuffer(class_2540 buf) {
        return new AbilityReference((class_2960)buf.method_43827(class_2540::method_10810), buf.method_19772());
    }

    public String toString() {
        if (this.powerId == null) {
            return this.abilityId;
        }
        return String.valueOf(this.powerId) + "#" + this.abilityId;
    }

    public int hashCode() {
        return Objects.hash(this.powerId, this.abilityId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbilityReference)) {
            return false;
        }
        AbilityReference that = (AbilityReference)o;
        return Objects.equals(this.powerId, that.powerId) && Objects.equals(this.abilityId, that.abilityId);
    }
}

