/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_7833;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.SyncType;
import net.threetag.palladium.util.property.TextureAlignmentProperty;
import net.threetag.palladium.util.property.TextureReferenceProperty;
import net.threetag.palladium.util.property.Vec3Property;
import net.threetag.palladiumcore.registry.client.OverlayRegistry;

public class GuiOverlayAbility
extends Ability {
    public static final PalladiumProperty<TextureReference> TEXTURE = new TextureReferenceProperty("texture").sync(SyncType.SELF).configurable("Texture path for the gui overlay");
    public static final PalladiumProperty<Integer> TEXTURE_WIDTH = new IntegerProperty("texture_width").sync(SyncType.SELF).configurable("Width of the texture file");
    public static final PalladiumProperty<Integer> TEXTURE_HEIGHT = new IntegerProperty("texture_height").sync(SyncType.SELF).configurable("Width of the texture file");
    public static final PalladiumProperty<class_243> TRANSLATE = new Vec3Property("translate").sync(SyncType.SELF).configurable("Translation of the rendered object");
    public static final PalladiumProperty<class_243> ROTATE = new Vec3Property("rotate").sync(SyncType.SELF).configurable("Rotation of the rendered object");
    public static final PalladiumProperty<class_243> SCALE = new Vec3Property("scale").sync(SyncType.SELF).configurable("Scale of the rendered object");
    public static final PalladiumProperty<TextureAlignmentProperty.TextureAlignment> ALIGNMENT = new TextureAlignmentProperty("alignment").sync(SyncType.SELF).configurable("Determines how the image is aligned on the screen");

    public GuiOverlayAbility() {
        this.withProperty(TEXTURE, TextureReference.normal(new class_2960("textures/gui/presets/isles.png")));
        this.withProperty(TEXTURE_WIDTH, 256);
        this.withProperty(TEXTURE_HEIGHT, 256);
        this.withProperty(TRANSLATE, class_243.field_1353);
        this.withProperty(ROTATE, class_243.field_1353);
        this.withProperty(SCALE, new class_243(1.0, 1.0, 1.0));
        this.withProperty(ALIGNMENT, TextureAlignmentProperty.TextureAlignment.STRETCH);
    }

    @Override
    public boolean isEffect() {
        return true;
    }

    @Override
    public String getDocumentationDescription() {
        return "Displays a gui overlay on the screen.";
    }

    @Environment(value=EnvType.CLIENT)
    public static class Renderer
    implements OverlayRegistry.IngameOverlay {
        public void render(class_310 minecraft, class_329 gui, class_332 guiGraphics, float partialTicks, int width, int height) {
            List<AbilityInstance> entries = AbilityUtil.getEnabledEntries((class_1309)minecraft.field_1724, (Ability)Abilities.GUI_OVERLAY.get()).stream().sorted((a1, a2) -> (int)(a1.getProperty(GuiOverlayAbility.TRANSLATE).field_1350 - a2.getProperty(GuiOverlayAbility.TRANSLATE).field_1350)).toList();
            for (AbilityInstance entry : entries) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                class_2960 texture = entry.getProperty(TEXTURE).getTexture(DataContext.forAbility((class_1309)minecraft.field_1724, entry));
                Integer textureWidth = entry.getProperty(TEXTURE_WIDTH);
                Integer textureHeight = entry.getProperty(TEXTURE_HEIGHT);
                TextureAlignmentProperty.TextureAlignment alignment = entry.getProperty(ALIGNMENT);
                class_243 translate = entry.getProperty(TRANSLATE);
                class_243 rotate = entry.getProperty(ROTATE);
                class_243 scale = entry.getProperty(SCALE);
                guiGraphics.method_51448().method_22903();
                if (alignment.isStretched()) {
                    scale = scale.method_18805((double)((float)width / (float)textureWidth.intValue()), (double)((float)height / (float)textureHeight.intValue()), 1.0);
                }
                guiGraphics.method_51448().method_22904(translate.field_1352 + (double)textureWidth.intValue() * scale.field_1352 / 2.0, translate.field_1351 + (double)textureWidth.intValue() * scale.field_1351 / 2.0, translate.field_1350);
                if (!alignment.isStretched()) {
                    int horizontal = alignment.getHorizontal();
                    int vertical = alignment.getVertical();
                    if (horizontal > 0) {
                        guiGraphics.method_51448().method_46416(horizontal == 1 ? (float)(width - textureWidth) / 2.0f : (float)(width - textureWidth), 0.0f, 0.0f);
                    }
                    if (vertical > 0) {
                        guiGraphics.method_51448().method_46416(0.0f, vertical == 1 ? (float)(height - textureHeight) / 2.0f : (float)(height - textureHeight), 0.0f);
                    }
                }
                if (rotate.field_1352 != 0.0) {
                    guiGraphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees((float)rotate.field_1352));
                }
                if (rotate.field_1351 != 0.0) {
                    guiGraphics.method_51448().method_22907(class_7833.field_40716.rotationDegrees((float)rotate.field_1351));
                }
                if (rotate.field_1350 != 0.0) {
                    guiGraphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees((float)rotate.field_1350));
                }
                this.renderImage(guiGraphics, texture, scale, textureWidth, textureHeight);
                RenderSystem.disableBlend();
                guiGraphics.method_51448().method_22909();
            }
        }

        private void renderImage(class_332 guiGraphics, class_2960 texture, class_243 scale, int textureWidth, int textureHeight) {
            guiGraphics.method_51448().method_22905((float)scale.field_1352, (float)scale.field_1351, (float)scale.field_1350);
            guiGraphics.method_25291(texture, -textureWidth / 2, -textureHeight / 2, 0, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
        }
    }
}

