/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import net.minecraft.class_1309;
import net.minecraft.class_3532;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AnimationTimer;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;
import net.threetag.palladium.util.property.SyncType;

public class VibrateAbility
extends Ability
implements AnimationTimer {
    public static final PalladiumProperty<Integer> VALUE = new IntegerProperty("value").sync(SyncType.NONE).disablePersistence();
    public static final PalladiumProperty<Integer> PREV_VALUE = new IntegerProperty("prev_value").sync(SyncType.NONE).disablePersistence();

    @Override
    public void registerUniqueProperties(PropertyManager manager) {
        manager.register(VALUE, 0);
        manager.register(PREV_VALUE, 0);
    }

    @Override
    public void tick(class_1309 entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        int value = entry.getProperty(VALUE);
        entry.setUniqueProperty(PREV_VALUE, value);
        if (enabled && value < 10) {
            entry.setUniqueProperty(VALUE, value + 1);
        } else if (!enabled && value > 0) {
            entry.setUniqueProperty(VALUE, value - 1);
        }
    }

    @Override
    public float getAnimationValue(AbilityInstance entry, float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)entry.getProperty(PREV_VALUE).intValue(), (float)entry.getProperty(VALUE).intValue()) / 10.0f;
    }

    @Override
    public float getAnimationTimer(AbilityInstance entry, float partialTick, boolean maxedOut) {
        if (maxedOut) {
            return 10.0f;
        }
        return class_3532.method_16439((float)partialTick, (float)entry.getProperty(PREV_VALUE).intValue(), (float)entry.getProperty(VALUE).intValue());
    }

    @Override
    public boolean isEffect() {
        return true;
    }

    @Override
    public String getDocumentationDescription() {
        return "Adds a vibration effect to the player.";
    }
}

