/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_757;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class GuiUtil {
    public static void drawItem(class_332 graphics, class_1799 stack, int hash, boolean renderOverlay, @Nullable String text) {
        boolean flatLight;
        if (stack.method_7960()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_918 itemRenderer = mc.method_1480();
        class_1087 bakedModel = itemRenderer.method_4019(stack, null, (class_1309)mc.field_1724, hash);
        class_310.method_1551().method_1531().method_4619(class_1723.field_21668).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.method_22903();
        modelViewStack.method_34425(graphics.method_51448().method_23760().method_23761());
        modelViewStack.method_22905(1.0f, -1.0f, 1.0f);
        modelViewStack.method_22905(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        boolean bl = flatLight = !bakedModel.method_24304();
        if (flatLight) {
            class_308.method_24210();
        }
        itemRenderer.method_23179(stack, class_811.field_4317, false, new class_4587(), (class_4597)bufferSource, 0xF000F0, class_4608.field_21444, bakedModel);
        bufferSource.method_22993();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            class_308.method_24211();
        }
        modelViewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        if (renderOverlay) {
            float cooldown;
            class_289 t = class_289.method_1348();
            class_327 font = mc.field_1772;
            if (stack.method_7947() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.method_7947()) : text;
                graphics.method_51448().method_22903();
                graphics.method_51448().method_22904(9.0 - (double)font.method_1727(s), 1.0, 20.0);
                font.method_27521(s, 0.0f, 0.0f, 0xFFFFFF, true, graphics.method_51448().method_23760().method_23761(), (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
                bufferSource.method_22993();
                graphics.method_51448().method_22909();
            }
            if (stack.method_31578()) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                int barWidth = stack.method_31579();
                int barColor = stack.method_31580();
                GuiUtil.draw(graphics, t, -6, 5, 13, 2, 0, 0, 0, 255);
                GuiUtil.draw(graphics, t, -6, 5, barWidth, 1, barColor >> 16 & 0xFF, barColor >> 8 & 0xFF, barColor & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
            }
            float f = cooldown = mc.field_1724 == null ? 0.0f : mc.field_1724.method_7357().method_7905(stack.method_7909(), mc.method_1488());
            if (cooldown > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                GuiUtil.draw(graphics, t, -8, class_3532.method_15375((float)(16.0f * (1.0f - cooldown))) - 8, 16, class_3532.method_15386((float)(16.0f * cooldown)), 255, 255, 255, 127);
                RenderSystem.enableDepthTest();
            }
        }
    }

    private static void draw(class_332 graphics, class_289 t, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        if (width <= 0 || height <= 0) {
            return;
        }
        RenderSystem.setShader(class_757::method_34540);
        Matrix4f m = graphics.method_51448().method_23760().method_23761();
        class_287 renderer = t.method_1349();
        renderer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        renderer.method_22918(m, (float)x, (float)y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(m, (float)x, (float)(y + height), 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(m, (float)(x + width), (float)(y + height), 0.0f).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22918(m, (float)(x + width), (float)y, 0.0f).method_1336(red, green, blue, alpha).method_1344();
        t.method_1350();
    }

    public static void drawContinuousTexturedBox(class_4587 poseStack, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int borderSize, float zLevel) {
        GuiUtil.drawContinuousTexturedBox(poseStack, x, y, u, v, width, height, textureWidth, textureHeight, borderSize, borderSize, borderSize, borderSize, zLevel);
    }

    public static void drawContinuousTexturedBox(class_4587 poseStack, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        GuiUtil.drawTexturedModalRect(poseStack, x, y, u, v, leftBorder, topBorder, zLevel);
        GuiUtil.drawTexturedModalRect(poseStack, x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        GuiUtil.drawTexturedModalRect(poseStack, x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        GuiUtil.drawTexturedModalRect(poseStack, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            GuiUtil.drawTexturedModalRect(poseStack, x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            GuiUtil.drawTexturedModalRect(poseStack, x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                GuiUtil.drawTexturedModalRect(poseStack, x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            GuiUtil.drawTexturedModalRect(poseStack, x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            GuiUtil.drawTexturedModalRect(poseStack, x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public static void drawTexturedModalRect(class_4587 poseStack, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        class_289 tessellator = class_289.method_1348();
        class_287 wr = tessellator.method_1349();
        wr.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        wr.method_22918(matrix, (float)x, (float)(y + height), zLevel).method_22913((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)(x + width), (float)(y + height), zLevel).method_22913((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)(x + width), (float)y, zLevel).method_22913((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).method_1344();
        wr.method_22918(matrix, (float)x, (float)y, zLevel).method_22913((float)u * 0.00390625f, (float)v * 0.00390625f).method_1344();
        tessellator.method_1350();
    }
}

