/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.threetag.palladium.compat.curiostinkets.CuriosTrinketsSlotInv;
import net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerSlot {
    private static final Map<class_1304, PlayerSlot> EQUIPMENT_SLOTS = new HashMap<class_1304, PlayerSlot>();
    private static final Map<String, PlayerSlot> SLOTS = new HashMap<String, PlayerSlot>();

    @NotNull
    public static PlayerSlot get(class_1304 slot) {
        return Objects.requireNonNull(PlayerSlot.get(slot.method_5923()));
    }

    @Nullable
    public static PlayerSlot get(String name) {
        for (class_1304 slot : class_1304.values()) {
            if (!slot.method_5923().equalsIgnoreCase(name)) continue;
            return EQUIPMENT_SLOTS.computeIfAbsent(slot, EquipmentPlayerSlot::new);
        }
        if (name.startsWith("curios:")) {
            return SLOTS.computeIfAbsent(name, n -> new CurioTrinketSlot(true, name.substring("curios:".length())));
        }
        if (name.startsWith("trinkets:")) {
            return SLOTS.computeIfAbsent(name, n -> new CurioTrinketSlot(false, name.substring("trinkets:".length())));
        }
        return null;
    }

    public abstract List<class_1799> getItems(class_1309 var1);

    public abstract void setItem(class_1309 var1, class_1799 var2);

    public abstract void clear(class_1309 var1);

    public abstract Type getType();

    @Nullable
    public class_1304 getEquipmentSlot() {
        return null;
    }

    private static class CurioTrinketSlot
    extends PlayerSlot {
        private final boolean curios;
        private final String slot;

        public CurioTrinketSlot(boolean curios, String slot) {
            this.curios = curios;
            this.slot = slot;
        }

        @Override
        public List<class_1799> getItems(class_1309 entity) {
            return CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, this.slot);
        }

        @Override
        public void setItem(class_1309 entity, class_1799 stack) {
            CuriosTrinketsUtil.getInstance().getSlot(entity, this.slot).setStackInSlot(0, stack);
        }

        @Override
        public void clear(class_1309 entity) {
            CuriosTrinketsSlotInv inv = CuriosTrinketsUtil.getInstance().getSlot(entity, this.slot);
            for (int i = 0; i < inv.getSlots(); ++i) {
                inv.setStackInSlot(i, class_1799.field_8037);
            }
        }

        @Override
        public Type getType() {
            return Type.CURIOS_TRINKET;
        }

        public String toString() {
            return (this.curios ? "curios:" : "trinkets:") + this.slot;
        }
    }

    public static enum Type {
        EQUIPMENT_SLOT,
        CURIOS_TRINKET;

    }

    private static class EquipmentPlayerSlot
    extends PlayerSlot {
        private final class_1304 slot;

        public EquipmentPlayerSlot(class_1304 slot) {
            this.slot = slot;
        }

        @Override
        public List<class_1799> getItems(class_1309 entity) {
            return Collections.singletonList(entity.method_6118(this.slot));
        }

        @Override
        public void setItem(class_1309 entity, class_1799 stack) {
            entity.method_5673(this.slot, stack);
        }

        @Override
        public void clear(class_1309 entity) {
            entity.method_5673(this.slot, class_1799.field_8037);
        }

        @Override
        @Nullable
        public class_1304 getEquipmentSlot() {
            return this.slot;
        }

        @Override
        public Type getType() {
            return Type.EQUIPMENT_SLOT;
        }

        public String toString() {
            return this.slot.method_5923();
        }
    }
}

