/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.icon.IconSerializers;
import net.threetag.palladium.util.icon.TexturedIcon;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.NotNull;

public record ExperienceIcon(int amount, boolean level) implements IIcon
{
    private static final TexturedIcon BACKGROUND_ICON = new TexturedIcon(Palladium.id("textures/icon/experience.png"));

    @Override
    public void draw(class_310 mc, class_332 guiGraphics, DataContext context, int x, int y, int width, int height) {
        BACKGROUND_ICON.draw(mc, guiGraphics, context, x, y, width, height);
        class_4587 stack = guiGraphics.method_51448();
        stack.method_22903();
        stack.method_46416((float)x, (float)y, 0.0f);
        if (width != 16 || height != 16) {
            stack.method_22905((float)width / 16.0f, (float)height / 16.0f, 1.0f);
        }
        String text = this.amount + (this.level ? "L" : "");
        guiGraphics.method_51433(mc.field_1772, text, 9, 8, 0, false);
        guiGraphics.method_51433(mc.field_1772, text, 7, 8, 0, false);
        guiGraphics.method_51433(mc.field_1772, text, 8, 9, 0, false);
        guiGraphics.method_51433(mc.field_1772, text, 8, 7, 0, false);
        guiGraphics.method_51433(mc.field_1772, text, 8, 8, 8453920, false);
        stack.method_22909();
    }

    public IconSerializer<ExperienceIcon> getSerializer() {
        return (IconSerializer)IconSerializers.EXPERIENCE.get();
    }

    @Override
    public String toString() {
        return "ExperienceIcon{amount=" + this.amount + ", level=" + this.level + "}";
    }

    public static class Serializer
    extends IconSerializer<ExperienceIcon> {
        @Override
        @NotNull
        public ExperienceIcon fromJSON(JsonObject json) {
            return new ExperienceIcon(GsonUtil.getAsIntMin(json, "amount", 0), class_3518.method_15258((JsonObject)json, (String)"level", (boolean)true));
        }

        @Override
        public ExperienceIcon fromNBT(class_2487 nbt) {
            return new ExperienceIcon(nbt.method_10550("Amount"), nbt.method_10577("Level"));
        }

        @Override
        public JsonObject toJSON(ExperienceIcon icon) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("amount", (Number)icon.amount);
            jsonObject.addProperty("level", Boolean.valueOf(icon.level));
            return jsonObject;
        }

        @Override
        public class_2487 toNBT(ExperienceIcon icon) {
            class_2487 tag = new class_2487();
            tag.method_10569("Amount", icon.amount);
            tag.method_10556("Level", icon.level);
            return tag;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Experience Icon");
            builder.setDescription("Displays an experience amount as an icon.");
            builder.addProperty("amount", Integer.class).description("Amount of experience points/level").required().exampleJson((JsonElement)new JsonPrimitive((Number)3));
            builder.addProperty("level", Boolean.class).description("Determines if icon should display level or not").fallback(true).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
    }
}

