/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3489;
import net.minecraft.class_3518;
import net.minecraft.class_4587;
import net.minecraft.class_6862;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.GuiUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.icon.IconSerializers;

public record IngredientIcon(class_1856 ingredient) implements IIcon
{
    @Override
    public void draw(class_310 mc, class_332 guiGraphics, DataContext context, int x, int y, int width, int height) {
        class_4587 stack = guiGraphics.method_51448();
        stack.method_22903();
        stack.method_22904((double)x + (double)width / 2.0, (double)y + (double)height / 2.0, 100.0);
        if (width != 16 || height != 16) {
            int s = Math.min(width, height);
            stack.method_22905((float)s / 16.0f, (float)s / 16.0f, (float)s / 16.0f);
        }
        int stackIndex = (int)(System.currentTimeMillis() / 1000L % (long)this.ingredient.method_8105().length);
        GuiUtil.drawItem(guiGraphics, this.ingredient.method_8105()[stackIndex], 0, true, null);
        stack.method_22909();
    }

    public IconSerializer<IngredientIcon> getSerializer() {
        return (IconSerializer)IconSerializers.INGREDIENT.get();
    }

    @Override
    public String toString() {
        return "IngredientIcon{ingredient=" + String.valueOf(this.ingredient.method_8089()) + "}";
    }

    public static class Serializer
    extends IconSerializer<IngredientIcon> {
        @Override
        public IngredientIcon fromJSON(JsonObject json) {
            return new IngredientIcon(class_1856.method_52177((JsonElement)json.get("ingredient")));
        }

        @Override
        public IngredientIcon fromNBT(class_2487 nbt) {
            return new IngredientIcon(class_1856.method_52177((JsonElement)class_3518.method_15285((String)nbt.method_10558("Ingredient"))));
        }

        @Override
        public JsonObject toJSON(IngredientIcon icon) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("ingredient", icon.ingredient.method_8089());
            return jsonObject;
        }

        @Override
        public class_2487 toNBT(IngredientIcon icon) {
            class_2487 tag = new class_2487();
            tag.method_10582("Ingredient", icon.ingredient.method_8089().toString());
            return tag;
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Ingredient Icon");
            builder.setDescription("Circles through the items of an ingredient.");
            builder.addProperty("ingredient", class_1856.class).description("Ingredient for the item").required().exampleJson(class_1856.method_8106((class_6862)class_3489.field_18317).method_8089());
        }
    }
}

