/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2158;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.server.MinecraftServer;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.util.property.PalladiumProperty;

public class CommandFunctionProperty
extends PalladiumProperty<CommandFunctionParsing> {
    public CommandFunctionProperty(String key) {
        super(key);
    }

    @Override
    public CommandFunctionParsing fromJSON(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return new CommandFunctionParsing(this.fixCmd(jsonElement.getAsString()));
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            lines.add(this.fixCmd(jsonArray.get(i).getAsString()));
        }
        return new CommandFunctionParsing(lines);
    }

    private String fixCmd(String cmd) {
        while (cmd.startsWith("/")) {
            cmd = cmd.substring(1);
        }
        return cmd;
    }

    @Override
    public JsonElement toJSON(CommandFunctionParsing value) {
        JsonArray array = new JsonArray();
        for (String line : value.getLines()) {
            array.add(line);
        }
        return array;
    }

    @Override
    public CommandFunctionParsing fromNBT(class_2520 tag, CommandFunctionParsing defaultValue) {
        if (tag instanceof class_2499) {
            class_2499 listTag = (class_2499)tag;
            ArrayList<String> lines = new ArrayList<String>();
            for (int i = 0; i < listTag.size(); ++i) {
                lines.add(listTag.method_10608(i));
            }
            return new CommandFunctionParsing(lines);
        }
        return defaultValue;
    }

    @Override
    public class_2520 toNBT(CommandFunctionParsing value) {
        class_2499 listTag = new class_2499();
        for (String s : value.getLines()) {
            listTag.add((Object)class_2519.method_23256((String)s));
        }
        return listTag;
    }

    @Override
    public CommandFunctionParsing fromBuffer(class_2540 buf) {
        return new CommandFunctionParsing(buf.method_34066(class_2540::method_19772));
    }

    @Override
    public void toBuffer(class_2540 buf, Object value) {
        buf.method_34062(((CommandFunctionParsing)value).getLines(), class_2540::method_10814);
    }

    @Override
    public String getString(CommandFunctionParsing value) {
        return value == null ? null : Arrays.toString(value.getLines().toArray());
    }

    public static class CommandFunctionParsing {
        private final List<String> lines;
        private class_2158 commandFunction;
        private boolean error = false;

        public CommandFunctionParsing(List<String> lines) {
            this.lines = lines;
        }

        public CommandFunctionParsing(String line) {
            this.lines = Collections.singletonList(line);
        }

        public class_2158 getCommandFunction(MinecraftServer server) {
            if (this.error) {
                return null;
            }
            if (this.commandFunction == null) {
                try {
                    class_2168 commandSourceStack = new class_2168(class_2165.field_17395, class_243.field_1353, class_241.field_1340, null, 2, "", class_5244.field_39003, server, null);
                    this.commandFunction = class_2158.method_9195((class_2960)Palladium.id("parsed"), (CommandDispatcher)server.method_3734().method_9235(), (class_2168)commandSourceStack, this.lines);
                }
                catch (Exception e) {
                    AddonPackLog.error(e.getMessage(), new Object[0]);
                    this.error = true;
                }
            }
            return this.commandFunction;
        }

        public List<String> getLines() {
            return this.lines;
        }
    }
}

