/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.builder;

import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.resources.ResourceLocation;

public abstract class AddonBuilder<T>
implements Supplier<T> {
    private final ResourceLocation id;
    private T built;

    protected AddonBuilder(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    protected abstract T create();

    @Override
    public T get() {
        if (this.built == null) {
            try {
                this.built = this.create();
            }
            catch (Exception e) {
                CrashReport report = CrashReport.m_127521_((Throwable)e, (String)("Error while building " + String.valueOf(this.id)));
                this.fillReport(report);
                throw new ReportedException(report);
            }
        }
        return this.built;
    }

    protected CrashReportCategory fillReport(CrashReport crashReport) {
        CrashReportCategory reportCategory = crashReport.m_127516_("Addon", 1);
        reportCategory.m_128159_("Resource name", (Object)this.id);
        return reportCategory;
    }
}

