/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.builder;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.BlockParser;
import net.threetag.palladium.block.AddonBlock;
import net.threetag.palladium.block.IAddonBlock;

public class BlockBuilder
extends AddonBuilder<Block> {
    private final JsonObject json;
    private ResourceLocation typeSerializerId = null;
    private MapColor mapColor;
    private SoundType soundType;
    private float destroyTime;
    private float explosionResistance;
    private boolean noOcclusion = false;
    private boolean requiresCorrectToolForDrops = false;
    private String renderType = null;

    public BlockBuilder(ResourceLocation id, JsonObject json) {
        super(id);
        this.json = json;
    }

    @Override
    protected Block create() {
        BlockParser.BlockTypeSerializer serializer;
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(this.mapColor).m_60913_(this.destroyTime, this.explosionResistance);
        if (this.soundType != null) {
            properties.m_60918_(this.soundType);
        }
        if (this.noOcclusion) {
            properties.m_60955_();
        }
        if (this.requiresCorrectToolForDrops) {
            properties.m_60999_();
        }
        if (this.typeSerializerId == null) {
            this.typeSerializerId = BlockParser.FALLBACK_SERIALIZER;
        }
        if ((serializer = BlockParser.getTypeSerializer(this.typeSerializerId)) == null) {
            AddonPackLog.warning("Unknown block type '" + String.valueOf(this.typeSerializerId) + "', falling back to '" + String.valueOf(BlockParser.FALLBACK_SERIALIZER) + "'", new Object[0]);
        }
        IAddonBlock block = serializer != null ? serializer.parse(this.json, properties) : new AddonBlock(properties);
        block.setRenderType(this.renderType);
        return (Block)block;
    }

    public BlockBuilder type(ResourceLocation serializerId) {
        this.typeSerializerId = serializerId;
        return this;
    }

    public BlockBuilder mapColor(MapColor color) {
        this.mapColor = color;
        return this;
    }

    public BlockBuilder soundType(SoundType soundType) {
        this.soundType = soundType;
        return this;
    }

    public BlockBuilder destroyTime(float destroyTime) {
        this.destroyTime = destroyTime;
        return this;
    }

    public BlockBuilder explosionResistance(float explosionResistance) {
        this.explosionResistance = explosionResistance;
        return this;
    }

    public BlockBuilder renderType(String name) {
        this.renderType = name;
        return this;
    }

    public BlockBuilder noOcclusion() {
        this.noOcclusion = true;
        return this;
    }

    public BlockBuilder requiresCorrectToolForDrops() {
        this.requiresCorrectToolForDrops = true;
        return this;
    }
}

