/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.builder;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import org.jetbrains.annotations.Nullable;

public class ParticleTypeBuilder
extends AddonBuilder<ParticleType<?>> {
    private boolean overrideLimiter = false;
    private RenderType renderType = RenderType.PARTICLE_SHEET_OPAQUE;
    private TextureType textureType = TextureType.RANDOM;
    private int lifetime = 100;
    private boolean hasPhysics = true;
    private float gravity = 0.02f;
    private float quadSize = 1.0f;
    private int brightness = -1;

    public ParticleTypeBuilder(ResourceLocation id) {
        super(id);
    }

    @Override
    protected ParticleType<?> create() {
        return new SimpleParticleType(this.overrideLimiter);
    }

    public ParticleTypeBuilder enableOverrideLimiter(boolean overrideLimiter) {
        this.overrideLimiter = overrideLimiter;
        return this;
    }

    public ParticleTypeBuilder renderType(RenderType renderType) {
        this.renderType = renderType;
        return this;
    }

    public ParticleTypeBuilder textureType(TextureType textureType) {
        this.textureType = textureType;
        return this;
    }

    public ParticleTypeBuilder lifetime(int lifetime) {
        this.lifetime = lifetime;
        return this;
    }

    public ParticleTypeBuilder hasPhysics(boolean hasPhysics) {
        this.hasPhysics = hasPhysics;
        return this;
    }

    public ParticleTypeBuilder gravity(float gravity) {
        this.gravity = gravity;
        return this;
    }

    public ParticleTypeBuilder quadSize(float quadSize) {
        this.quadSize = quadSize;
        return this;
    }

    public ParticleTypeBuilder brightness(int brightness) {
        this.brightness = brightness;
        return this;
    }

    public static enum RenderType {
        TERRAIN_SHEET("terrain_sheet"),
        PARTICLE_SHEET_OPAQUE("opaque"),
        PARTICLE_SHEET_TRANSLUCENT("translucent"),
        PARTICLE_SHEET_LIT("lit"),
        NO_RENDER("no_render");

        private final String name;

        private RenderType(String name) {
            this.name = name;
        }

        public static RenderType byName(String name) {
            for (RenderType value : RenderType.values()) {
                if (!value.name.equalsIgnoreCase(name)) continue;
                return value;
            }
            return null;
        }
    }

    public static enum TextureType {
        RANDOM("random"),
        AGING("aging");

        private final String name;

        private TextureType(String name) {
            this.name = name;
        }

        public static TextureType byName(String name) {
            for (TextureType value : TextureType.values()) {
                if (!value.name.equalsIgnoreCase(name)) continue;
                return value;
            }
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final ParticleTypeBuilder builder;
        private final SpriteSet sprite;

        public Provider(ParticleTypeBuilder builder, SpriteSet sprite) {
            this.builder = builder;
            this.sprite = sprite;
        }

        @Nullable
        public net.minecraft.client.particle.Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new Particle(level, this.sprite, x, y, z, xSpeed, ySpeed, zSpeed, this.builder);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Particle
    extends TextureSheetParticle {
        private final ParticleTypeBuilder builder;
        private final SpriteSet spriteSet;

        protected Particle(ClientLevel clientLevel, SpriteSet spriteSet, double x, double y, double z, double xd, double yd, double zd, ParticleTypeBuilder builder) {
            super(clientLevel, x, y, z, xd, yd, zd);
            this.m_172260_(xd, yd, zd);
            this.builder = builder;
            this.spriteSet = spriteSet;
            this.f_107225_ = this.builder.lifetime;
            this.f_107219_ = this.builder.hasPhysics;
            this.f_107226_ = this.builder.gravity;
            this.f_107663_ = this.builder.quadSize;
            if (this.f_107226_ == 0.0f) {
                this.m_172260_(0.0, 0.0, 0.0);
            }
            if (this.builder.textureType == TextureType.RANDOM) {
                this.m_108335_(this.spriteSet);
            } else if (this.builder.textureType == TextureType.AGING) {
                this.m_108339_(this.spriteSet);
            }
        }

        public void m_5989_() {
            super.m_5989_();
            if (this.builder.textureType == TextureType.AGING) {
                this.m_108339_(this.spriteSet);
            }
        }

        public int m_6355_(float partialTick) {
            if (this.builder.brightness < 0) {
                return super.m_6355_(partialTick);
            }
            int i = super.m_6355_(partialTick);
            int k = i >> 16 & 0xFF;
            return this.builder.brightness | k << 16;
        }

        public ParticleRenderType m_7556_() {
            switch (this.builder.renderType) {
                case NO_RENDER: {
                    return ParticleRenderType.f_107434_;
                }
                case PARTICLE_SHEET_LIT: {
                    return ParticleRenderType.f_107432_;
                }
                case PARTICLE_SHEET_OPAQUE: {
                    return ParticleRenderType.f_107430_;
                }
                case PARTICLE_SHEET_TRANSLUCENT: {
                    return ParticleRenderType.f_107431_;
                }
                case TERRAIN_SHEET: {
                    return ParticleRenderType.f_107429_;
                }
            }
            return ParticleRenderType.f_107434_;
        }
    }
}

