/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.threetag.palladium.client.dynamictexture.DynamicTexture;
import net.threetag.palladium.client.dynamictexture.transformer.TransformedTexture;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.util.context.DataContext;
import org.jetbrains.annotations.Nullable;

public class DefaultDynamicTexture
extends DynamicTexture {
    private final String base;
    @Nullable
    private String output;

    public DefaultDynamicTexture(ResourceLocation texture) {
        this(texture.toString(), null);
    }

    public DefaultDynamicTexture(String base, @Nullable String output) {
        this.base = base;
        this.output = output;
    }

    @Override
    public ResourceLocation getTexture(DataContext context) {
        ResourceLocation output;
        if (this.transformers.isEmpty()) {
            return new ResourceLocation(DefaultDynamicTexture.replaceVariables(this.base, context, this.textureVariableMap));
        }
        if (this.output == null || this.output.isEmpty()) {
            this.output = this.base;
            for (String var : this.textureVariableMap.keySet()) {
                if (this.output.contains("#" + var)) continue;
                this.output = this.output + "_#" + var;
            }
        }
        if (!Minecraft.m_91087_().m_91097_().f_118468_.containsKey(output = new ResourceLocation(DefaultDynamicTexture.replaceVariables(this.output, context, this.textureVariableMap)))) {
            String s = DefaultDynamicTexture.replaceVariables(this.base, context, this.textureVariableMap);
            ResourceLocation texture = new ResourceLocation(s);
            Minecraft.m_91087_().m_91097_().m_118495_(output, (AbstractTexture)new TransformedTexture(texture, null, this.transformers, context, transformerPath -> DefaultDynamicTexture.replaceVariables(transformerPath, context, this.textureVariableMap)));
        }
        return output;
    }

    public static String replaceVariables(String base, DataContext context, Map<String, ITextureVariable> textureVariableMap) {
        for (Map.Entry<String, ITextureVariable> entry : textureVariableMap.entrySet()) {
            ITextureVariable variable = entry.getValue();
            base = variable.replace(base, entry.getKey(), context);
        }
        return base;
    }
}

