/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.threetag.palladium.client.dynamictexture.DefaultDynamicTexture;
import net.threetag.palladium.client.dynamictexture.DynamicTexture;
import net.threetag.palladium.client.dynamictexture.ImageCache;
import net.threetag.palladium.client.dynamictexture.NativeImageCached;
import net.threetag.palladium.client.dynamictexture.transformer.TransformedTexture;
import net.threetag.palladium.util.context.DataContext;
import org.jetbrains.annotations.Nullable;

public class EntityDynamicTexture
extends DynamicTexture {
    public static boolean IGNORE_SKIN_CHANGE = false;
    private final boolean ignoreSkinChange;
    @Nullable
    private String output;

    public EntityDynamicTexture(boolean ignoreSkinChange) {
        this.ignoreSkinChange = ignoreSkinChange;
    }

    @Override
    public ResourceLocation getTexture(DataContext context) {
        ResourceLocation output;
        if (this.ignoreSkinChange) {
            IGNORE_SKIN_CHANGE = true;
            ResourceLocation texture = Minecraft.m_91087_().m_91290_().m_114382_(context.getEntity()).m_5478_(context.getEntity());
            IGNORE_SKIN_CHANGE = false;
            return texture;
        }
        ResourceLocation texture = Minecraft.m_91087_().m_91290_().m_114382_(context.getEntity()).m_5478_(context.getEntity());
        if (this.transformers.isEmpty()) {
            return texture;
        }
        if (this.output == null || this.output.isEmpty()) {
            this.output = texture.toString();
            for (String var : this.textureVariableMap.keySet()) {
                if (this.output.contains("#" + var)) continue;
                this.output = this.output + "_#" + var;
            }
        }
        if (!Minecraft.m_91087_().m_91097_().f_118468_.containsKey(output = new ResourceLocation(DefaultDynamicTexture.replaceVariables(this.output, context, this.textureVariableMap)))) {
            Minecraft.m_91087_().m_91097_().m_118495_(output, (AbstractTexture)new TransformedTexture(texture, EntityDynamicTexture.getNativeImageIfPossible(texture), this.transformers, context, transformerPath -> DefaultDynamicTexture.replaceVariables(transformerPath, context, this.textureVariableMap)));
        }
        return output;
    }

    public static ImageCache getNativeImageIfPossible(ResourceLocation texture) {
        AbstractTexture abstractTexture = Minecraft.m_91087_().m_91097_().m_118506_(texture);
        if (abstractTexture instanceof NativeImageCached) {
            NativeImageCached httpTexture = (NativeImageCached)abstractTexture;
            return httpTexture.palladium$getImageCache();
        }
        return null;
    }
}

