/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.util.Mth;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;

public abstract class AbstractFloatTextureVariable
implements ITextureVariable {
    private final List<Pair<Operation, JsonPrimitive>> operations;

    public AbstractFloatTextureVariable(List<Pair<Operation, JsonPrimitive>> operations) {
        this.operations = operations;
    }

    @Override
    public Object get(DataContext context) {
        Number f = Float.valueOf(this.getNumber(context));
        for (Pair<Operation, JsonPrimitive> pair : this.operations) {
            f = ((Operation)((Object)pair.getFirst())).function.apply(Float.valueOf(((Number)f).floatValue()), (JsonPrimitive)pair.getSecond());
        }
        return f;
    }

    public abstract float getNumber(DataContext var1);

    public static List<Pair<Operation, JsonPrimitive>> parseOperations(JsonObject json) {
        LinkedList<Pair<Operation, JsonPrimitive>> operations = new LinkedList<Pair<Operation, JsonPrimitive>>();
        for (Map.Entry entry : json.entrySet()) {
            Operation operation = Operation.getOperationByName((String)entry.getKey());
            if (operation == null) continue;
            operations.add((Pair<Operation, JsonPrimitive>)Pair.of((Object)((Object)operation), (Object)((JsonElement)entry.getValue()).getAsJsonPrimitive()));
        }
        return operations;
    }

    public static void addDocumentationFields(JsonDocumentationBuilder builder) {
        builder.addProperty("add", Float.class).description("This value will be added on top of the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(5.2f)));
        builder.addProperty("subtract", Float.class).description("This value will be subtracted from the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(3.1f)));
        builder.addProperty("multiply", Float.class).description("This value will be subtracted with the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(2.5f)));
        builder.addProperty("divide", Float.class).description("This value will be divided to the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(7.5f)));
        builder.addProperty("min", Float.class).description("Using this value will set a minimum limit for the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(5.5f)));
        builder.addProperty("max", Float.class).description("Using this value will set a maximum limit for the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(123.4f)));
        builder.addProperty("modulo", Float.class).description("Using this value will apply a modulo operation to the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)5.0));
    }

    public static enum Operation {
        ADD("add", Float::sum),
        SUBTRACT("subtract", (input, subtract) -> Float.valueOf(input.floatValue() - subtract.floatValue())),
        MULTIPLY("multiply", (input, multiply) -> Float.valueOf(input.floatValue() * multiply.floatValue())),
        DIVIDE("divide", (input, multiply) -> Float.valueOf(input.floatValue() / multiply.floatValue())),
        MIN("min", Float::max),
        MAX("max", Float::min),
        MODULO("modulo", (input, modulo) -> Float.valueOf(input.floatValue() % modulo.floatValue())),
        ROUND((input, obj) -> {
            String mode = obj.getAsString();
            if (mode.equalsIgnoreCase("to_int")) {
                return input.intValue();
            }
            if (mode.equalsIgnoreCase("ceil")) {
                return Mth.m_14167_((float)input.floatValue());
            }
            if (mode.equalsIgnoreCase("floor")) {
                return Mth.m_14143_((float)input.floatValue());
            }
            return input;
        }, "round");

        private final String name;
        private final BiFunction<Float, JsonPrimitive, Number> function;

        private Operation(BiFunction<Float, JsonPrimitive, Number> function, String name) {
            this.name = name;
            this.function = function;
        }

        private Operation(String name, BiFunction<Float, Float, Number> function) {
            this.name = name;
            this.function = (input, value) -> {
                if (value.isNumber()) {
                    return (Number)function.apply((Float)input, Float.valueOf(value.getAsFloat()));
                }
                return input;
            };
        }

        public static Operation getOperationByName(String name) {
            for (Operation operation : Operation.values()) {
                if (!operation.name.equalsIgnoreCase(name)) continue;
                return operation;
            }
            return null;
        }
    }
}

