/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.variable.AbstractIntegerTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladium.power.ability.AnimationTimer;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;

public class AnimationTimerAbilityVariable
extends AbstractIntegerTextureVariable {
    private final AbilityReference reference;

    public AnimationTimerAbilityVariable(ResourceLocation powerId, String abilityId, List<Pair<AbstractIntegerTextureVariable.Operation, Integer>> operations) {
        super(operations);
        this.reference = new AbilityReference(powerId, abilityId);
    }

    @Override
    public int getNumber(DataContext context) {
        LivingEntity livingEntity = context.getLivingEntity();
        if (livingEntity != null) {
            Ability ability;
            AbilityInstance entry = this.reference.getEntry(livingEntity);
            if (entry == null || !((ability = entry.getConfiguration().getAbility()) instanceof AnimationTimer)) {
                return 0;
            }
            AnimationTimer animationTimer = (AnimationTimer)((Object)ability);
            return (int)animationTimer.getAnimationTimer(entry, 1.0f);
        }
        return 0;
    }

    public static class Serializer
    implements ITextureVariableSerializer {
        @Override
        public ITextureVariable parse(JsonObject json) {
            return new AnimationTimerAbilityVariable(GsonUtil.getAsResourceLocation(json, "power"), GsonHelper.m_13906_((JsonObject)json, (String)"ability"), AbstractIntegerTextureVariable.parseOperations(json));
        }

        @Override
        public String getDocumentationDescription() {
            return "Returns the timer of an animation timer ability. The math operations can be arranged in any order and are fully optional!";
        }

        @Override
        public void addDocumentationFields(JsonDocumentationBuilder builder) {
            builder.setTitle("Animation Timer Ability");
            builder.addProperty("power", ResourceLocation.class).description("ID of the power the ability is in.").required().exampleJson((JsonElement)new JsonPrimitive("example:power_id"));
            builder.addProperty("ability", String.class).description("Key of the ability that is being looked for.").required().exampleJson((JsonElement)new JsonPrimitive("ability_key"));
            AbstractIntegerTextureVariable.addDocumentationFields(builder);
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("animation_timer_ability");
        }
    }
}

