/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.energybeam;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.energybeam.EnergyBeamManager;
import net.threetag.palladium.client.energybeam.EnergyBeamRenderer;
import net.threetag.palladium.client.energybeam.LaserBeamRenderer;
import net.threetag.palladium.client.particleemitter.ParticleEmitter;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.util.PerspectiveValue;
import net.threetag.palladium.util.json.GsonUtil;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class EnergyBeam {
    private final BodyPart anchor;
    private final PerspectiveValue<Vector3f> offset;
    private final EnergyBeamRenderer renderer;
    private final List<Particle> particles;

    public EnergyBeam(BodyPart anchor, PerspectiveValue<Vector3f> offset, EnergyBeamRenderer renderer, List<Particle> particles) {
        this.anchor = anchor;
        this.offset = offset;
        this.renderer = renderer;
        this.particles = particles;
    }

    public Vec3 getOriginPosition(AbstractClientPlayer player, float partialTick) {
        return BodyPart.getInWorldPosition(this.anchor, this.offset.get(), player, partialTick);
    }

    public void spawnParticles(Level level, Vec3 pos) {
        for (Particle particle : this.particles) {
            particle.spawn(level, pos);
        }
    }

    public void render(AbstractClientPlayer player, Vec3 anchor, Vec3 target, float lengthMultiplier, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, boolean isFirstPerson, float partialTick) {
        Vec3 origin = this.getOriginPosition(player, partialTick).m_82546_(anchor);
        target = target.m_82546_(anchor);
        poseStack.m_85836_();
        poseStack.m_85837_(origin.f_82479_, origin.f_82480_, origin.f_82481_);
        this.renderer.render(player, origin, target, lengthMultiplier, poseStack, bufferSource, packedLightIn, isFirstPerson, partialTick);
        poseStack.m_85849_();
    }

    public static EnergyBeam fromJson(JsonObject json) {
        EnergyBeamRenderer.Serializer serializer = EnergyBeamManager.getRenderer(GsonUtil.getAsResourceLocation(json, "type", LaserBeamRenderer.Serializer.ID));
        if (serializer == null) {
            throw new JsonParseException("Unknown energy beam renderer '" + String.valueOf(GsonUtil.getAsResourceLocation(json, "type", LaserBeamRenderer.Serializer.ID)) + "'");
        }
        return new EnergyBeam(BodyPart.fromJson(GsonHelper.m_13906_((JsonObject)json, (String)"body_part")), PerspectiveValue.getFromJson(json, "offset", j -> GsonUtil.convertToVector3f(j, "offset").div(16.0f, -16.0f, 16.0f), new Vector3f()), serializer.fromJson(json), json.has("particles") ? GsonUtil.fromListOrPrimitive(json.get("particles"), jsonElement -> Particle.fromJson(GsonHelper.m_13918_((JsonElement)jsonElement, (String)"particles[].$"))) : Collections.emptyList());
    }

    public record Particle(ParticleType<?> particleType, String options, ParticleEmitter emitter) {
        public static Particle fromJson(JsonObject json) {
            ResourceLocation particleTypeId = GsonUtil.getAsResourceLocation(json, "particle_type");
            if (!BuiltInRegistries.f_257034_.m_7804_(particleTypeId)) {
                throw new JsonParseException("Unknown particle type '" + String.valueOf(particleTypeId) + "'");
            }
            ParticleType particleType = (ParticleType)BuiltInRegistries.f_257034_.m_7745_(particleTypeId);
            String options = GsonHelper.m_13851_((JsonObject)json, (String)"options", (String)"");
            ParticleEmitter emitter = ParticleEmitter.fromJson(json);
            return new Particle(particleType, options, emitter);
        }

        public void spawn(Level level, Vec3 pos) {
            try {
                ParticleType<?> type = this.particleType;
                ParticleOptions options = type.m_123743_().m_5739_(type, new StringReader(" " + this.options.trim() + " "));
                this.emitter.spawnAtPosition(level, pos, options);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }
}

