/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.threetag.palladium.client.model.animation.PalladiumAnimation;
import net.threetag.palladium.client.model.animation.PalladiumAnimationRegistry;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.entity.PlayerModelCacheExtension;
import net.threetag.palladium.mixin.client.AgeableListModelInvoker;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AnimationTimer;
import net.threetag.palladium.power.ability.VibrateAbility;
import net.threetag.palladium.util.Easing;
import org.joml.Vector3f;

public class HumanoidRendererModifications {
    public static float ALPHA_MULTIPLIER = 1.0f;
    private static float CACHED_SHRINK = 0.0f;
    public static BodyPart.ModifiedBodyPartResult CACHED_HIDE_RESULT = null;
    public static float CACHED_LIMB_SWING;
    public static float CACHED_LIMB_SWING_AMOUNT;
    public static float CACHED_AGE_IN_TICKS;
    public static float CACHED_NET_HEAD_YAW;
    public static float CACHED_HEAD_PITCH;

    public static void preSetup(LivingEntityRenderer renderer, LivingEntity entity, HumanoidModel model, PoseStack poseStack, float partialTicks) {
        if (model instanceof AgeableListModelInvoker) {
            AgeableListModelInvoker invoker = (AgeableListModelInvoker)model;
            PalladiumAnimationRegistry.resetPoses(invoker.invokeHeadParts(), invoker.invokeBodyParts());
        }
        if (renderer instanceof PlayerRenderer) {
            PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
            if (entity instanceof AbstractClientPlayer) {
                AbstractClientPlayer player = (AbstractClientPlayer)entity;
                PalladiumAnimation.PoseStackResult result = PalladiumAnimationRegistry.setupRotations(playerRenderer, player, poseStack, partialTicks);
                if (player instanceof PlayerModelCacheExtension) {
                    PlayerModelCacheExtension ext = (PlayerModelCacheExtension)player;
                    ext.palladium$setBodyAnimationResult(result);
                }
            }
        }
    }

    public static void preRender(LivingEntityRenderer renderer, LivingEntity entity, HumanoidModel model, PoseStack poseStack, float partialTick) {
        if (!PalladiumAnimationRegistry.SKIP_ANIMATIONS) {
            PalladiumAnimationRegistry.applyAnimations(model, entity, CACHED_LIMB_SWING, CACHED_LIMB_SWING_AMOUNT, CACHED_AGE_IN_TICKS, CACHED_NET_HEAD_YAW, CACHED_HEAD_PITCH);
        }
        if (!FirstPersonMode.isFirstPersonPass()) {
            BodyPart.resetBodyParts(entity, model);
        }
        CACHED_HIDE_RESULT = BodyPart.getModifiedBodyParts(entity, false);
        BodyPart.hideHiddenOrRemovedParts(model, entity, CACHED_HIDE_RESULT);
        float scale = AnimationTimer.getValue(entity, (Ability)Abilities.SHRINK_BODY_OVERLAY.get(), partialTick, Easing.INOUTSINE);
        if (scale != 0.0f) {
            float f;
            CACHED_SHRINK = f = -0.11f * scale;
            Vector3f vec = new Vector3f(f, f, f);
            for (BodyPart value : BodyPart.values()) {
                ModelPart part = value.getModelPart(model);
                if (!value.isOverlay() || part == null) continue;
                part.m_253072_(vec);
            }
        }
    }

    public static void preLayers(LivingEntityRenderer renderer, LivingEntity entity, HumanoidModel model, PoseStack poseStack) {
        if (CACHED_SHRINK != 0.0f) {
            float f = -CACHED_SHRINK;
            CACHED_SHRINK = 0.0f;
            Vector3f vec = new Vector3f(f, f, f);
            for (BodyPart value : BodyPart.values()) {
                ModelPart part = value.getModelPart(model);
                if (!value.isOverlay() || part == null) continue;
                part.m_253072_(vec);
            }
        }
    }

    public static void postLayers(LivingEntityRenderer renderer, LivingEntity entity, HumanoidModel model, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float partialTick) {
        float vibrate = AnimationTimer.getValue(entity, (Ability)Abilities.VIBRATE.get(), partialTick, Easing.INOUTSINE);
        if (vibrate > 0.0f) {
            ALPHA_MULTIPLIER = 0.3f;
            Minecraft minecraft = Minecraft.m_91087_();
            boolean bl = renderer.m_5933_(entity);
            boolean bl2 = !bl && !entity.m_20177_((Player)minecraft.f_91074_);
            boolean bl3 = minecraft.m_91314_((Entity)entity);
            RenderType renderType = renderer.m_7225_(entity, bl, true, bl3);
            int intensity = VibrateAbility.getIntensity(entity);
            RandomSource rand = RandomSource.m_216327_();
            for (int i = 0; i < intensity; ++i) {
                poseStack.m_85836_();
                poseStack.m_252880_((rand.m_188501_() - 0.5f) / 15.0f * vibrate, 0.0f, (rand.m_188501_() - 0.5f) / 15.0f * vibrate);
                if (renderType != null) {
                    VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
                    int m = LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)renderer.m_6931_(entity, partialTick));
                    renderer.m_7200_().m_7695_(poseStack, vertexConsumer, packedLight, m, 1.0f, 1.0f, 1.0f, bl2 ? 0.15f : 1.0f);
                }
                poseStack.m_85849_();
                poseStack.m_85836_();
                poseStack.m_252880_((rand.m_188501_() - 0.5f) / 7.0f * vibrate, 0.0f, (rand.m_188501_() - 0.5f) / 7.0f * vibrate);
                if (!entity.m_5833_()) {
                    for (Object layer : renderer.f_115291_) {
                        if (!(layer instanceof RenderLayer)) continue;
                        RenderLayer renderLayer = (RenderLayer)layer;
                        renderLayer.m_6494_(poseStack, buffer, packedLight, (Entity)entity, CACHED_LIMB_SWING, CACHED_LIMB_SWING_AMOUNT, partialTick, CACHED_AGE_IN_TICKS, CACHED_NET_HEAD_YAW, CACHED_HEAD_PITCH);
                    }
                }
                poseStack.m_85849_();
            }
            ALPHA_MULTIPLIER = 1.0f;
        }
        if (entity instanceof PlayerModelCacheExtension) {
            PlayerModelCacheExtension ext = (PlayerModelCacheExtension)entity;
            for (BodyPart part : BodyPart.values()) {
                ModelPart orig = part.getModelPart(model);
                ModelPart cache = part.getModelPart((HumanoidModel<?>)ext.palladium$getCachedModel());
                if (orig == null || cache == null) continue;
                cache.m_171322_(orig.m_171308_());
            }
        }
    }

    public static void applyRemovedBodyParts(HumanoidModel model) {
        BodyPart.ModifiedBodyPartResult hideResult = CACHED_HIDE_RESULT;
        if (hideResult == null) {
            return;
        }
        if (hideResult.isRemoved(BodyPart.HEAD)) {
            model.f_102809_.f_104207_ = false;
            model.f_102808_.f_104207_ = false;
        }
        if (hideResult.isRemoved(BodyPart.CHEST)) {
            model.f_102810_.f_104207_ = false;
        }
        if (hideResult.isRemoved(BodyPart.RIGHT_ARM)) {
            model.f_102811_.f_104207_ = false;
        }
        if (hideResult.isRemoved(BodyPart.LEFT_ARM)) {
            model.f_102812_.f_104207_ = false;
        }
        if (hideResult.isRemoved(BodyPart.RIGHT_LEG)) {
            model.f_102813_.f_104207_ = false;
        }
        if (hideResult.isRemoved(BodyPart.LEFT_LEG)) {
            model.f_102814_.f_104207_ = false;
        }
    }
}

