/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.entity;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.renderer.entity.PlayerSkinInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSkinFetcher {
    private static final Map<String, GameProfile> CACHED_NAME_PROFILES = new ConcurrentHashMap<String, GameProfile>();
    private static final Map<String, PlayerSkinInfo> CACHED_NAME_SKINS = new ConcurrentHashMap<String, PlayerSkinInfo>();
    private static final Pattern UUID_PATTERN = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();

    @Nullable
    public static ResourceLocation getOrLoadPlayerSkin(String username) {
        PlayerSkinInfo PlayerSkinInfo2 = PlayerSkinFetcher.getPlayerSkinInfo(username);
        if (PlayerSkinInfo2.hasFailed() || PlayerSkinInfo2.isLoading()) {
            return null;
        }
        return PlayerSkinInfo2.getTexture();
    }

    @Nullable
    public static String getOrLoadModelType(String username) {
        PlayerSkinInfo PlayerSkinInfo2 = PlayerSkinFetcher.getPlayerSkinInfo(username);
        if (PlayerSkinInfo2.hasFailed() || PlayerSkinInfo2.isLoading()) {
            return null;
        }
        return PlayerSkinInfo2.getModelName();
    }

    @Nullable
    public static PlayerSkinInfo getLoadedPlayerSkinInfo(@NotNull String username) {
        PlayerSkinInfo PlayerSkinInfo2 = PlayerSkinFetcher.getPlayerSkinInfo(username);
        if (PlayerSkinInfo2.hasFailed() || PlayerSkinInfo2.isLoading()) {
            return null;
        }
        return PlayerSkinInfo2;
    }

    public static PlayerSkinInfo getPlayerSkinInfo(@NotNull String username) {
        LocalPlayer mcPlayer = Minecraft.m_91087_().f_91074_;
        if (mcPlayer != null && username.equalsIgnoreCase(mcPlayer.m_36316_().getName())) {
            return CACHED_NAME_SKINS.computeIfAbsent(username.toLowerCase(Locale.ROOT), s -> {
                PlayerSkinInfo PlayerSkinInfo2 = new PlayerSkinInfo();
                PlayerSkinInfo2.set(mcPlayer.m_108564_(), mcPlayer.m_108560_());
                return PlayerSkinInfo2;
            });
        }
        return CACHED_NAME_SKINS.computeIfAbsent(username.toLowerCase(Locale.ROOT), key -> {
            Util.m_183991_().execute(() -> {
                GameProfile profile = PlayerSkinFetcher.getGameProfile(username);
                if (profile != null) {
                    Minecraft.m_91087_().m_91109_().m_118817_(profile, (type, resourceLocation, minecraftProfileTexture) -> {
                        if (type == MinecraftProfileTexture.Type.SKIN) {
                            String skinModel = minecraftProfileTexture.getMetadata("model");
                            if (skinModel == null) {
                                skinModel = "default";
                            }
                            CACHED_NAME_SKINS.computeIfAbsent(profile.getName().toLowerCase(Locale.ROOT), n -> new PlayerSkinInfo()).set(skinModel, resourceLocation);
                        }
                    }, true);
                } else {
                    CACHED_NAME_SKINS.computeIfAbsent(username.toLowerCase(Locale.ROOT), n -> new PlayerSkinInfo()).setFailed();
                }
            });
            return new PlayerSkinInfo();
        });
    }

    @Nullable
    public static GameProfile getGameProfile(@NotNull String name) {
        return CACHED_NAME_PROFILES.computeIfAbsent(name, key -> {
            JsonObject object = PlayerSkinFetcher.parseURL("https://api.mojang.com/users/profiles/minecraft/" + key + "?unsigned=false");
            if (object == null) {
                return null;
            }
            UUID uuid = PlayerSkinFetcher.fromStringWithoutDashes(GsonHelper.m_13906_((JsonObject)object, (String)"id"));
            String realName = GsonHelper.m_13906_((JsonObject)object, (String)"name");
            return new GameProfile(uuid, realName);
        });
    }

    @Nullable
    private static JsonObject parseURL(@NotNull String purl) {
        try {
            URI uri = new URI(purl);
            HttpRequest request = HttpRequest.newBuilder(uri).GET().build();
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IllegalStateException("Failed to do an HTTP request to: " + purl + " Response code: " + response.statusCode());
            }
            String responseBody = response.body();
            return JsonParser.parseString((String)responseBody).getAsJsonObject();
        }
        catch (Exception e) {
            Palladium.LOGGER.warn("Failed to fetch URL: {}", (Object)purl);
            return null;
        }
    }

    private static UUID fromStringWithoutDashes(@NotNull String uuid) {
        String correctedUUID = UUID_PATTERN.matcher(uuid).replaceAll("$1-$2-$3-$4-$5");
        return UUID.fromString(correctedUUID);
    }
}

