/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.threetag.palladium.client.renderer.entity.PlayerSkinInfo;
import net.threetag.palladium.power.ability.PlayerSkinChangeAbility;
import net.threetag.palladium.power.ability.SkinChangeAbility;
import org.jetbrains.annotations.Nullable;

public class PlayerSkinHandler {
    public static final List<Pair<Integer, ISkinProvider>> PROVIDER = new ArrayList<Pair<Integer, ISkinProvider>>();

    public static ResourceLocation getCurrentSkin(GameProfile gameProfile, ResourceLocation defaultSkin) {
        AbstractClientPlayer player = (AbstractClientPlayer)Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46003_(gameProfile.getId());
        if (player instanceof PlayerSkinChangeHandler) {
            PlayerSkinChangeHandler handler = (PlayerSkinChangeHandler)player;
            PlayerSkinInfo skin = handler.palladium$getOverridenSkin();
            return skin != null ? skin.getTexture() : defaultSkin;
        }
        return defaultSkin;
    }

    public static String getCurrentModelType(GameProfile gameProfile, String modelType) {
        AbstractClientPlayer player = (AbstractClientPlayer)Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46003_(gameProfile.getId());
        if (player instanceof PlayerSkinChangeHandler) {
            PlayerSkinChangeHandler handler = (PlayerSkinChangeHandler)player;
            PlayerSkinInfo skin = handler.palladium$getOverridenSkin();
            return skin != null ? skin.getModelName() : modelType;
        }
        return modelType;
    }

    public static void registerSkinProvider(int priority, ISkinProvider provider) {
        PROVIDER.add((Pair<Integer, ISkinProvider>)Pair.of((Object)priority, (Object)provider));
        PROVIDER.sort((p1, p2) -> (Integer)p2.getFirst() - (Integer)p1.getFirst());
    }

    static {
        PlayerSkinHandler.registerSkinProvider(30, new SkinChangeAbility.SkinProvider());
        PlayerSkinHandler.registerSkinProvider(40, new PlayerSkinChangeAbility.SkinProvider());
    }

    public static interface PlayerSkinChangeHandler {
        @Nullable
        public PlayerSkinInfo palladium$getOverridenSkin();
    }

    public static interface ISkinProvider {
        public PlayerSkinInfo getSkin(AbstractClientPlayer var1, PlayerSkinInfo var2, PlayerSkinInfo var3);
    }
}

