/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.model.SuitStandBasePlateModel;
import net.threetag.palladium.client.model.SuitStandModel;
import net.threetag.palladium.client.renderer.renderlayer.ColorableSuitStandLayer;
import net.threetag.palladium.entity.SuitStand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuitStandRenderer
extends LivingEntityRenderer<SuitStand, SuitStandBasePlateModel> {
    public static final ResourceLocation DEFAULT_SKIN_LOCATION = Palladium.id("textures/entity/suit_stand.png");

    public SuitStandRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SuitStandBasePlateModel(context.m_174023_(SuitStandBasePlateModel.MODEL_LAYER_LOCATION)), 0.0f);
        this.m_115326_(new ColorableSuitStandLayer((RenderLayerParent<SuitStand, SuitStandBasePlateModel>)this, new SuitStandModel(context.m_174023_(SuitStandModel.MODEL_LAYER_LOCATION))));
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new ArmorStandArmorModel(context.m_174023_(ModelLayers.f_171208_)), (HumanoidModel)new ArmorStandArmorModel(context.m_174023_(ModelLayers.f_171261_)), context.m_266367_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), context.m_234598_()));
    }

    public void scale(SuitStand livingEntity, PoseStack matrixStack, float partialTickTime) {
        float scale = 0.9375f;
        matrixStack.m_85841_(scale, scale, scale);
        if (!livingEntity.m_31674_()) {
            matrixStack.m_252880_(0.0f, -0.0625f, 0.0f);
        }
    }

    protected void setupRotations(SuitStand entityLiving, PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotationYaw));
        float f = (float)(entityLiving.m_9236_().m_46467_() - entityLiving.f_31528_) + partialTicks;
        if (f < 5.0f) {
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14031_((float)(f / 1.5f * (float)Math.PI)) * 3.0f));
        }
    }

    protected boolean shouldShowName(SuitStand entity) {
        double d = this.f_114476_.m_114471_((Entity)entity);
        float f = entity.m_6047_() ? 32.0f : 64.0f;
        return !(d >= (double)(f * f)) && entity.m_20151_();
    }

    @Nullable
    public RenderType getRenderType(SuitStand livingEntity, boolean bodyVisible, boolean translucent, boolean glowing) {
        if (!livingEntity.m_31677_()) {
            return super.m_7225_((LivingEntity)livingEntity, bodyVisible, translucent, glowing);
        }
        ResourceLocation resourceLocation = this.getTextureLocation(livingEntity);
        if (translucent) {
            return RenderType.m_110454_((ResourceLocation)resourceLocation, (boolean)false);
        }
        return bodyVisible ? RenderType.m_110443_((ResourceLocation)resourceLocation, (boolean)false) : null;
    }

    @NotNull
    public ResourceLocation getTextureLocation(SuitStand entity) {
        return DEFAULT_SKIN_LOCATION;
    }
}

