/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.item.armor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.threetag.palladium.client.renderer.item.armor.ArmorModelData;
import net.threetag.palladium.client.renderer.item.armor.ArmorTextureData;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.item.Openable;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.context.DataContextType;
import org.jetbrains.annotations.Nullable;

public class ArmorRendererConditions {
    public static final String BASE_TEXTURE = "default";
    public static final String OPENED_TEXTURE = "open";
    public final List<ConditionedTextureKey> conditions = new LinkedList<ConditionedTextureKey>();

    public String getTexture(DataContext context, ArmorTextureData textures) {
        Item item;
        Object key = BASE_TEXTURE;
        ItemStack stack = context.getItem();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof Openable) {
            Openable openable = (Openable)item;
            int max = openable.getOpeningTime(stack);
            if (max <= 0 && openable.isOpen(stack)) {
                key = OPENED_TEXTURE;
            } else if (max > 0 && !textures.has((String)(key = "open_" + openable.getOpeningProgress(context.getItem())))) {
                key = OPENED_TEXTURE;
            }
        }
        if (!textures.has((String)key)) {
            key = BASE_TEXTURE;
        }
        for (ConditionedTextureKey condition : this.conditions) {
            if (condition.textureKey == null || !condition.isActive(context)) continue;
            key = condition.textureKey;
        }
        return key;
    }

    public String getModelLayer(DataContext context, ArmorModelData models) {
        Openable openable;
        Item item;
        Object key = BASE_TEXTURE;
        if (context.has(DataContextType.ITEM) && (item = context.getItem().m_41720_()) instanceof Openable && (openable = (Openable)item).getOpeningProgress(context.getItem()) > 0) {
            if (openable.getOpeningTime(context.getItem()) <= 0) {
                key = OPENED_TEXTURE;
            } else {
                key = "open_" + openable.getOpeningProgress(context.getItem());
                if (!models.has((String)key)) {
                    key = OPENED_TEXTURE;
                }
            }
        }
        if (!models.has((String)key)) {
            key = BASE_TEXTURE;
        }
        for (ConditionedTextureKey condition : this.conditions) {
            if (condition.modelKey == null || !condition.isActive(context)) continue;
            key = condition.modelKey;
        }
        return key;
    }

    public static ArmorRendererConditions fromJson(@Nullable JsonArray jsonArray) {
        if (jsonArray == null) {
            return new ArmorRendererConditions();
        }
        ArmorRendererConditions cond = new ArmorRendererConditions();
        for (JsonElement jsonElement : jsonArray) {
            JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"conditions.$");
            String textureKey = GsonHelper.m_13851_((JsonObject)json, (String)"texture", null);
            String modelKey = GsonHelper.m_13851_((JsonObject)json, (String)"model_layer", null);
            cond.conditions.add(0, new ConditionedTextureKey(textureKey, modelKey, ConditionSerializer.listFromJSON(json.get("if"), ConditionEnvironment.ASSETS)));
        }
        return cond;
    }

    private record ConditionedTextureKey(String textureKey, String modelKey, List<Condition> conditions) {
        public boolean isActive(DataContext context) {
            for (Condition condition : this.conditions) {
                if (condition.active(context)) continue;
                return false;
            }
            return true;
        }
    }
}

