/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.entity.BodyPart;

public abstract class AbstractPackRenderLayer
implements IPackRenderLayer {
    protected final List<Condition> conditions = new ArrayList<Condition>();
    protected final List<Condition> thirdPersonConditions = new ArrayList<Condition>();
    protected final List<Condition> firstPersonConditions = new ArrayList<Condition>();
    protected final List<BodyPart> hiddenBodyParts = new ArrayList<BodyPart>();

    @Override
    public IPackRenderLayer addCondition(Condition condition, IPackRenderLayer.PerspectiveConditionContext context) {
        if (context == IPackRenderLayer.PerspectiveConditionContext.BOTH) {
            this.conditions.add(condition);
        } else if (context == IPackRenderLayer.PerspectiveConditionContext.THIRD_PERSON) {
            this.thirdPersonConditions.add(condition);
        } else if (context == IPackRenderLayer.PerspectiveConditionContext.FIRST_PERSON) {
            this.firstPersonConditions.add(condition);
        }
        return this;
    }

    public AbstractPackRenderLayer addHiddenBodyPart(BodyPart bodyPart) {
        if (!this.hiddenBodyParts.contains((Object)bodyPart)) {
            this.hiddenBodyParts.add(bodyPart);
        }
        return this;
    }

    @Override
    public List<BodyPart> getHiddenBodyParts(LivingEntity entity) {
        return IPackRenderLayer.conditionsFulfilled((Entity)entity, this.conditions, this.thirdPersonConditions) ? this.hiddenBodyParts : Collections.emptyList();
    }
}

