/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.client.renderer.renderlayer.AbstractPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.RenderLayerStates;
import net.threetag.palladium.entity.PalladiumLivingEntityExtension;
import net.threetag.palladium.util.RenderUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class LightningSparksRenderLayer
extends AbstractPackRenderLayer {
    private final float frequency;
    private final int amount;
    private final DynamicColor coreColor;
    private final DynamicColor glowColor;
    private final float coreOpacity;
    private final float glowOpacity;
    private final float thickness;
    private final float scale;
    private final boolean normalTransparency;

    public LightningSparksRenderLayer(float frequency, int amount, DynamicColor coreColor, DynamicColor glowColor, float coreOpacity, float glowOpacity, float thickness, float scale, boolean normalTransparency) {
        this.frequency = frequency;
        this.amount = amount;
        this.coreColor = coreColor;
        this.glowColor = glowColor;
        this.coreOpacity = coreOpacity;
        this.glowOpacity = glowOpacity;
        this.thickness = thickness;
        this.scale = scale;
        this.normalTransparency = normalTransparency;
    }

    public static LightningSparksRenderLayer parse(JsonObject json) {
        float frequency = GsonUtil.getAsFloatRanged(json, "frequency", 0.0f, 1.0f, 0.5f);
        int amount = GsonUtil.getAsIntMin(json, "amount", 0, 5);
        DynamicColor coreColor = DynamicColor.getFromJson(json, "core_color", DynamicColor.WHITE);
        DynamicColor glowColor = DynamicColor.getFromJson(json, "glow_color", DynamicColor.WHITE);
        float coreOpacity = GsonUtil.getAsFloatRanged(json, "core_opacity", 0.0f, 1.0f, 1.0f);
        float glowOpacity = GsonUtil.getAsFloatRanged(json, "glow_opacity", 0.0f, 1.0f, 1.0f);
        float thickness = GsonUtil.getAsFloatMin(json, "thickness", 0.001f, 0.02f);
        float scale = GsonUtil.getAsFloatMin(json, "scale", 0.0f, 1.0f);
        boolean normalTransparency = GsonHelper.m_13855_((JsonObject)json, (String)"normal_transparency", (boolean)false);
        return new LightningSparksRenderLayer(frequency, amount, coreColor, glowColor, coreOpacity, glowOpacity, thickness, scale, normalTransparency);
    }

    @Override
    public void render(DataContext context, PoseStack poseStack, MultiBufferSource bufferSource, EntityModel<Entity> parentModel, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity entity = context.getLivingEntity();
        State state = this.getState(entity);
        if (state != null && entity != null) {
            VertexConsumer vertexConsumer = bufferSource.m_6299_(this.normalTransparency ? PalladiumRenderTypes.LASER_NORMAL_TRANSPARENCY : PalladiumRenderTypes.LASER);
            for (Spark spark : state.sparks) {
                float opacity = 1.0f - Mth.m_14036_((float)(((float)spark.ticks + partialTicks) / 4.0f), (float)0.0f, (float)1.0f);
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 1.5f, 0.0f);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                poseStack.m_252880_(entity.m_20205_() * this.scale / -2.0f, entity.m_20206_() / 2.0f - entity.m_20206_() * this.scale / 2.0f, entity.m_20205_() * this.scale / -2.0f);
                LightningSparksRenderLayer.renderLightning(poseStack, vertexConsumer, spark.pos1, spark.pos2, this.coreColor.getColor(context), this.glowColor.getColor(context), opacity * this.coreOpacity, opacity * this.glowOpacity, this.thickness);
                LightningSparksRenderLayer.renderLightning(poseStack, vertexConsumer, spark.pos1, spark.pos3, this.coreColor.getColor(context), this.glowColor.getColor(context), opacity * this.coreOpacity, opacity * this.glowOpacity, this.thickness);
                poseStack.m_85849_();
            }
        }
    }

    private static void renderLightning(PoseStack poseStack, VertexConsumer consumer, Vec3 start, Vec3 end, Color coreColor, Color glowColor, float coreOpacity, float glowOpacity, float thickness) {
        poseStack.m_85836_();
        poseStack.m_85837_(start.f_82479_, start.f_82480_, start.f_82481_);
        RenderUtil.faceVec(poseStack, start, end);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        AABB box = new AABB((double)(-thickness / 2.0f), 0.0, (double)(-thickness / 2.0f), (double)(thickness / 2.0f), start.m_82554_(end), (double)(thickness / 2.0f));
        RenderUtil.renderFilledBox(poseStack, consumer, box, (float)coreColor.getRed() / 255.0f, (float)coreColor.getGreen() / 255.0f, (float)coreColor.getBlue() / 255.0f, coreOpacity, 0xF00000);
        RenderUtil.renderFilledBox(poseStack, consumer, box.m_82400_(0.03125), (float)glowColor.getRed() / 255.0f, (float)glowColor.getGreen() / 255.0f, (float)glowColor.getBlue() / 255.0f, 0.5f * glowOpacity, 0xF00000);
        poseStack.m_85849_();
    }

    @Nullable
    public State getState(LivingEntity entity) {
        if (entity instanceof PalladiumLivingEntityExtension) {
            State state;
            PalladiumLivingEntityExtension extension = (PalladiumLivingEntityExtension)entity;
            RenderLayerStates.State state2 = extension.palladium$getRenderLayerStates().getOrCreate(this);
            return state2 instanceof State ? (state = (State)state2) : null;
        }
        return null;
    }

    @Override
    public RenderLayerStates.State createState() {
        return new State(this);
    }

    public static class State
    extends RenderLayerStates.State {
        private final LightningSparksRenderLayer layer;
        private List<Spark> sparks = new ArrayList<Spark>();

        public State(LightningSparksRenderLayer layer) {
            this.layer = layer;
        }

        @Override
        public void tick(LivingEntity entity) {
            super.tick(entity);
            this.sparks.forEach(Spark::tick);
            this.sparks = this.sparks.stream().peek(Spark::tick).filter(s -> s.ticks < 5).collect(Collectors.toList());
            if (this.sparks.isEmpty() && IPackRenderLayer.conditionsFulfilled((Entity)entity, this.layer.conditions, this.layer.thirdPersonConditions) && Math.random() < (double)this.layer.frequency) {
                for (int i = 0; i < this.layer.amount; ++i) {
                    this.sparks.add(new Spark((Entity)entity, this.layer.scale, RandomSource.m_216327_()));
                }
            }
        }
    }

    public static class Spark {
        public final Vec3 pos1;
        public final Vec3 pos2;
        public final Vec3 pos3;
        private int ticks;

        public Spark(Entity entity, float scale, RandomSource randomSource) {
            Random random = new Random();
            this.pos1 = new Vec3((double)(entity.m_20205_() * scale * random.nextFloat()), (double)(entity.m_20206_() * scale * random.nextFloat()), (double)(entity.m_20205_() * scale * random.nextFloat()));
            this.pos2 = this.makePos(this.pos1, entity.m_20205_() * scale, entity.m_20206_() * scale, randomSource);
            this.pos3 = this.makePos(this.pos1, entity.m_20205_() * scale, entity.m_20206_() * scale, randomSource);
        }

        private Vec3 makePos(Vec3 center, float width, float height, RandomSource source) {
            float length = (width + height) / 20.0f;
            float x = (float)Mth.m_14008_((double)(center.f_82479_ + (double)((source.m_188501_() * 2.0f - 1.0f) * length)), (double)0.0, (double)width);
            float y = (float)Mth.m_14008_((double)(center.f_82480_ + (double)((source.m_188501_() * 2.0f - 1.0f) * length)), (double)0.0, (double)height);
            float z = (float)Mth.m_14008_((double)(center.f_82481_ + (double)((source.m_188501_() * 2.0f - 1.0f) * length)), (double)0.0, (double)width);
            return new Vec3((double)x, (double)y, (double)z);
        }

        private void tick() {
            ++this.ticks;
        }
    }
}

