/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.trail;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.LaserRenderer;
import net.threetag.palladium.client.renderer.entity.TrailSegmentEntityRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRendererManager;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.entity.PalladiumEntityExtension;
import net.threetag.palladium.entity.TrailSegmentEntity;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;

public class LightningTrailRenderer
extends TrailRenderer<Cache> {
    private final LaserRenderer laserRenderer;
    private final float spacing;
    private final int lifetime;
    private final int amount;
    private final float spreadX;
    private final float spreadY;

    public LightningTrailRenderer(LaserRenderer laserRenderer, float spacing, int lifetime, int amount, float spreadX, float spreadY) {
        this.laserRenderer = laserRenderer;
        this.spacing = spacing;
        this.lifetime = lifetime;
        this.amount = amount;
        this.spreadX = spreadX;
        this.spreadY = spreadY;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, TrailSegmentEntityRenderer trailRenderer, Entity livingEntity, TrailSegmentEntity<Cache> segment, float partialTick, float entityYaw) {
        PalladiumEntityExtension ext;
        List<TrailSegmentEntity<?>> trails;
        int index;
        if (livingEntity instanceof PalladiumEntityExtension && (index = (trails = (ext = (PalladiumEntityExtension)livingEntity).palladium$getTrailHandler().getTrails().get(this)).indexOf(segment)) == trails.size() - 1) {
            this.renderSegmentWithChild(DataContext.forEntity(livingEntity), poseStack, buffer, segment, trails, partialTick, index);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderSegmentWithChild(DataContext context, PoseStack poseStack, MultiBufferSource buffer, TrailSegmentEntity<Cache> segment, List<TrailSegmentEntity<?>> segments, float partialTick, int index) {
        if (index > 0) {
            TrailSegmentEntity<Cache> previousSegment = segments.get(index - 1);
            Cache cache = (Cache)segment.cache;
            Object previousC = previousSegment.cache;
            if (index == segments.size() - 1 && segment.parent.m_6084_()) {
                for (int i = 0; i < cache.offsets.length; ++i) {
                    Vec3 start = LightningTrailRenderer.getOffsetPos(segment, cache.offsets[i]);
                    Vec3 end = LightningTrailRenderer.getOffsetPos(segment.parent, cache.offsets[i]).m_82549_(segment.parent.m_20318_(partialTick).m_82546_(segment.m_20182_()));
                    float opacity = 1.0f - ((float)segment.f_19797_ + partialTick) / (float)segment.lifetime;
                    poseStack.m_85836_();
                    poseStack.m_85837_(start.f_82479_, start.f_82480_, start.f_82481_);
                    this.laserRenderer.length((float)start.m_82554_(end)).opacityAndSizeModifier(opacity).faceAndRender(context, poseStack, buffer, start, end, segment.parent.f_19797_ + i * 42, partialTick);
                    poseStack.m_85849_();
                }
            }
            if (previousC instanceof Cache) {
                Cache previousCache = (Cache)previousC;
                if (cache.offsets.length == previousCache.offsets.length && previousSegment.m_6084_()) {
                    for (int i = 0; i < cache.offsets.length; ++i) {
                        Vec3 start = LightningTrailRenderer.getOffsetPos(segment, cache.offsets[i]);
                        Vec3 end = LightningTrailRenderer.getOffsetPos(previousSegment, previousCache.offsets[i]).m_82549_(previousSegment.m_20182_().m_82546_(segment.m_20182_()));
                        float opacity = 1.0f - ((float)segment.f_19797_ + partialTick) / (float)segment.lifetime;
                        poseStack.m_85836_();
                        poseStack.m_85837_(start.f_82479_, start.f_82480_, start.f_82481_);
                        this.laserRenderer.length((float)start.m_82554_(end)).opacityAndSizeModifier(opacity).faceAndRender(context, poseStack, buffer, start, end, segment.parent.f_19797_ + i * 42, partialTick);
                        poseStack.m_85849_();
                    }
                    poseStack.m_85836_();
                    Vec3 offsetPos = previousSegment.m_20182_().m_82546_(segment.m_20182_());
                    poseStack.m_85837_(offsetPos.f_82479_, offsetPos.f_82480_, offsetPos.f_82481_);
                    this.renderSegmentWithChild(context, poseStack, buffer, previousSegment, segments, partialTick, index - 1);
                    poseStack.m_85849_();
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Vec3 getOffsetPos(Entity segment, Vec3 offset) {
        return new Vec3(offset.f_82479_ * (double)segment.m_20205_(), (double)segment.m_20206_() / 2.0 + offset.f_82480_ * (double)segment.m_20206_(), offset.f_82481_ * (double)segment.m_20205_());
    }

    @Override
    public TrailRenderer.SegmentCache createCache() {
        Random random = new Random();
        Vec3[] offsets = new Vec3[this.amount];
        for (int i = 0; i < this.amount; ++i) {
            double spacingY = 1.0 / (double)this.amount * (double)this.spreadY;
            offsets[i] = new Vec3((random.nextDouble() - 0.5) * (double)this.spreadX, spacingY * (double)this.amount / -2.0 + spacingY * (double)i + spacingY / 2.0 + (random.nextDouble() - 0.5) * spacingY / 1.5, (random.nextDouble() - 0.5) * (double)this.spreadX);
        }
        return new Cache(offsets);
    }

    @Override
    public float getSpacing() {
        return this.spacing;
    }

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    @Override
    public DynamicColor getColor() {
        return this.laserRenderer.getGlowColor();
    }

    public static class Cache
    extends TrailRenderer.SegmentCache {
        private final Vec3[] offsets;

        public Cache(Vec3[] offsets) {
            this.offsets = offsets;
        }
    }

    public static class Serializer
    implements TrailRendererManager.TypeSerializer {
        public TrailRenderer<Cache> parse(JsonObject json) {
            float spacing = GsonUtil.getAsFloatMin(json, "spacing", 0.1f, 1.0f);
            int lifetime = GsonUtil.getAsIntMin(json, "lifetime", 1, 20);
            int amount = GsonUtil.getAsIntMin(json, "amount", 1, 10);
            float spreadX = GsonUtil.getAsFloatMin(json, "spread_x", 0.0f, 1.0f);
            float spreadY = GsonUtil.getAsFloatMin(json, "spread_y", 0.0f, 1.0f);
            return new LightningTrailRenderer(LaserRenderer.fromJson(json, 1), spacing, lifetime, amount, spreadX, spreadY);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Lightning Trail");
            builder.setDescription("Flash-like lightning trail");
            builder.addProperty("spacing", Float.class).description("Determines the space between two trail segments").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("lifetime", Integer.class).description("Determines how long one trail segment stays alive (in ticks)").fallback(20).exampleJson((JsonElement)new JsonPrimitive((Number)20));
            builder.addProperty("amount", Integer.class).description("Determines how many lightnings the entity will generate behind it").fallback(7).exampleJson((JsonElement)new JsonPrimitive((Number)7));
            builder.addProperty("spread_x", Float.class).description("Determines the spread of a lightning position relative to the player on the X/horizontal axis. 1 means across the normal player hitbox, 0 means always in the middle.").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("spread_y", Float.class).description("Determines the spread of a lightning position relative to the player on the Y/vertical axis. 1 means across the normal player hitbox, 0 means always in the middle.").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            LaserRenderer.generateDocumentation(builder, 1, false);
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("lightning");
        }
    }
}

