/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.addonpack.log.AddonPackLogEntry;
import net.threetag.palladium.client.screen.ScrollPanel;

public class AddonPackLogEntryScreen
extends Screen {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public final Screen parent;
    private final AddonPackLogEntry entry;
    private Panel panel;

    protected AddonPackLogEntryScreen(Screen parent, AddonPackLogEntry entry) {
        super((Component)Component.m_237115_((String)"gui.palladium.addon_pack_log_entry"));
        this.parent = parent;
        this.entry = entry;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.panel = new Panel(this.f_96541_, this.f_96543_, this.f_96544_ - 64 - 48, 48, 0);
        this.m_7787_((GuiEventListener)this.panel);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.palladium.addon_pack_log_entry.copy_to_clipboard"), button -> Objects.requireNonNull(this.f_96541_).f_91068_.m_90911_(this.entry.getText() + "\n" + this.entry.getStacktrace())).m_252987_(this.f_96543_ / 2 - 310, this.f_96544_ - 64 + 32 - 10, 250, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.palladium.addon_pack_log_entry.upload_to_mclogs"), button -> {
            try {
                String url = this.uploadPastebin();
                Objects.requireNonNull(this.f_96541_).m_91152_((Screen)new ConfirmLinkScreen(b -> {
                    if (b) {
                        Util.m_137581_().m_137646_(url);
                    }
                    this.f_96541_.m_91152_((Screen)this);
                }, url, true));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).m_252987_(this.f_96543_ / 2 - 50, this.f_96544_ - 64 + 32 - 10, 250, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130660_, button -> Objects.requireNonNull(this.f_96541_).m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 + 310 - 70, this.f_96544_ - 64 + 32 - 10, 75, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        if (this.panel != null) {
            this.panel.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadPastebin() {
        HttpURLConnection connection = null;
        try {
            String line;
            URL url = new URL("https://api.mclo.gs/1/log");
            String urlParameters = "content=" + this.entry.getText() + "\n" + this.entry.getStacktrace();
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes().length));
            connection.setRequestProperty("Content-Language", "en-US");
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.close();
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuilder response = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                response.append(line);
            }
            rd.close();
            JsonObject jsonObject = (JsonObject)GsonHelper.m_13794_((Gson)GSON, (String)response.toString(), JsonObject.class);
            String string = GsonHelper.m_13906_((JsonObject)Objects.requireNonNull(jsonObject), (String)"url");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    class Panel
    extends ScrollPanel {
        private final List<FormattedCharSequence> lines1;
        private final List<FormattedCharSequence> lines2;

        public Panel(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.lines1 = AddonPackLogEntryScreen.this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)AddonPackLogEntryScreen.this.entry.getText()), this.width - 25);
            this.lines2 = AddonPackLogEntryScreen.this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)AddonPackLogEntryScreen.this.entry.getStacktrace()), this.width - 25);
        }

        @Override
        protected int getContentHeight() {
            return this.lines1.size() * 15 + 15 + this.lines2.size() * 15;
        }

        @Override
        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            Font font = Minecraft.m_91087_().f_91062_;
            RenderSystem.enableBlend();
            relativeY += 15;
            for (FormattedCharSequence processor : this.lines1) {
                guiGraphics.m_280649_(font, processor, this.left + 10, relativeY, 0xFEFEFE, false);
                relativeY += 15;
            }
            guiGraphics.m_280509_(this.left + 10, relativeY++, this.left + this.width - 10, relativeY, -65794);
            relativeY += 15;
            for (FormattedCharSequence processor : this.lines2) {
                guiGraphics.m_280648_(font, processor, this.left + 10, relativeY, 0xFEFEFE);
                relativeY += 15;
            }
            RenderSystem.disableBlend();
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }
}

